/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.blockentity.GenericContainerBlockEntity;
import net.tslat.aoa3.library.object.GenericItemStackHandler;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class LunarCreationTableBlockEntity
extends GenericContainerBlockEntity {
    private static final Component DEFAULT_NAME = Component.translatable((String)LocaleUtil.createContainerLocaleKey("lunar_creation_table"));
    private final GenericItemStackHandler itemHandler = new GenericItemStackHandler(9);

    public LunarCreationTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AoABlockEntities.LUNAR_CREATION_TABLE.get(), pos, state);
    }

    public int getContainerSize() {
        return 9;
    }

    public GenericItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public NonNullList<ItemStack> getItems() {
        return this.getItemHandler().getAllStacks();
    }

    public Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public CompoundTag saveContents(HolderLookup.Provider holderLookup) {
        return this.getItemHandler().serializeNBT(holderLookup);
    }

    @Override
    public void loadContents(HolderLookup.Provider holderLookup, CompoundTag compound) {
        this.getItemHandler().deserializeNBT(holderLookup, compound);
    }

    @Override
    public void clearContent() {
        this.getItemHandler().clear();
    }

    @Override
    public void setItemNoUpdate(int slot, ItemStack stack) {
        this.getItemHandler().setStackInSlot(slot, stack);
    }

    @Nullable
    public CraftingMenu createMenu(int containerId, final Inventory playerInventory) {
        CraftingMenu container = new CraftingMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos())){

            protected void clearContainer(Player player, Container container) {
                LunarCreationTableBlockEntity.this.setItems((NonNullList<ItemStack>)NonNullList.copyOf((Collection)this.craftSlots.getItems()));
                this.craftSlots.clearContent();
                super.clearContainer(player, container);
            }

            public void slotsChanged(Container inventory) {
                if (playerInventory.player.containerMenu == this) {
                    LunarCreationTableBlockEntity.this.setItems((NonNullList<ItemStack>)NonNullList.copyOf((Collection)this.craftSlots.getItems()));
                }
                super.slotsChanged(inventory);
            }

            public boolean stillValid(Player player) {
                return 1.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)AoABlocks.LUNAR_CREATION_TABLE.get()));
            }
        };
        NonNullList<ItemStack> contents = this.getItems();
        for (int i = 0; i < contents.size(); ++i) {
            container.craftSlots.setItem(i, (ItemStack)contents.get(i));
        }
        return container;
    }
}

