/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.menu.InfusionTableMenu;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.content.block.blockentity.GenericContainerBlockEntity;
import net.tslat.aoa3.library.object.GenericItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class InfusionTableBlockEntity
extends GenericContainerBlockEntity {
    private static final Component DEFAULT_NAME = Component.translatable((String)"container.aoa3.infusion_table");
    private final GenericItemStackHandler itemHandler = new GenericItemStackHandler(this.getContainerSize());

    public InfusionTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AoABlockEntities.INFUSION_TABLE.get(), pos, state);
    }

    public int getContainerSize() {
        return 11;
    }

    public GenericItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public NonNullList<ItemStack> getItems() {
        return this.getItemHandler().getAllStacks();
    }

    public Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public CompoundTag saveContents(HolderLookup.Provider holderLookup) {
        return this.getItemHandler().serializeNBT(holderLookup);
    }

    @Override
    public void loadContents(HolderLookup.Provider holderLookup, CompoundTag compound) {
        this.getItemHandler().deserializeNBT(holderLookup, compound);
    }

    @Override
    public void clearContent() {
        this.getItemHandler().clear();
        this.markUpdated();
    }

    public void setOutput(ItemStack itemStack) {
        this.setItem(10, itemStack);
    }

    @Override
    public void setItemNoUpdate(int slot, ItemStack stack) {
        this.getItemHandler().setStackInSlot(slot, stack);
    }

    @Nullable
    public InfusionTableMenu createMenu(int containerId, final Inventory playerInventory) {
        InfusionTableMenu container = new InfusionTableMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos())){

            protected void clearContainer(Player player, Container container) {
                InfusionTableBlockEntity.this.setItems(((TransientCraftingContainer)this.getInventory()).getItems());
                InfusionTableBlockEntity.this.setOutput(this.getOutputItem());
                ((TransientCraftingContainer)this.getInventory()).clearContent();
                super.clearContainer(player, container);
            }

            @Override
            public void slotsChanged(Container inventory) {
                if (playerInventory.player.containerMenu == this) {
                    InfusionTableBlockEntity.this.setItems(((TransientCraftingContainer)this.getInventory()).getItems());
                    InfusionTableBlockEntity.this.setOutput(this.getOutputItem());
                }
                super.slotsChanged(inventory);
            }
        };
        NonNullList<ItemStack> contents = this.getItems();
        for (int i = 0; i < 10 && i < contents.size(); ++i) {
            ((TransientCraftingContainer)container.getInventory()).setItem(i, (ItemStack)contents.get(i));
        }
        return container;
    }
}

