/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.menu.InfusedPressMenu;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.block.blockentity.GenericContainerBlockEntity;
import net.tslat.aoa3.content.recipe.InfusedPressCompressionRecipe;
import net.tslat.aoa3.content.recipe.InfusedPressDecompressionRecipe;
import net.tslat.aoa3.library.object.GenericItemStackHandler;
import net.tslat.aoa3.util.LocaleUtil;

public class InfusedPressBlockEntity
extends GenericContainerBlockEntity {
    private static final Component DEFAULT_NAME = Component.translatable((String)LocaleUtil.createContainerLocaleKey("infused_press"));
    private final InfusedPressItemHandler itemHandler = new InfusedPressItemHandler();

    public InfusedPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AoABlockEntities.INFUSED_PRESS.get(), pos, state);
    }

    public int getContainerSize() {
        return 10;
    }

    public GenericItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public NonNullList<ItemStack> getItems() {
        return this.getItemHandler().getAllStacks();
    }

    public Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public CompoundTag saveContents(HolderLookup.Provider holderLookup) {
        return this.getItemHandler().serializeNBT(holderLookup);
    }

    @Override
    public void loadContents(HolderLookup.Provider holderLookup, CompoundTag compound) {
        this.getItemHandler().deserializeNBT(holderLookup, compound);
    }

    @Override
    public void clearContent() {
        this.getItemHandler().clear();
    }

    public void setOutput(ItemStack itemStack) {
        this.setItem(9, itemStack);
    }

    @Override
    public void setItemNoUpdate(int slot, ItemStack stack) {
        this.getItemHandler().setStackInSlot(slot, stack);
    }

    public boolean compress() {
        GenericRecipeInput inputs = new GenericRecipeInput((List<ItemStack>)this.getItemHandler().getAllStacks());
        return this.getLevel().getRecipeManager().getRecipeFor((RecipeType)AoARecipes.INFUSED_PRESS_COMPRESSION.type().get(), (RecipeInput)inputs, this.level).map(recipe -> {
            ItemStack result = ((InfusedPressCompressionRecipe)recipe.value()).assemble(inputs, (HolderLookup.Provider)this.level.registryAccess());
            if (!result.isEmpty()) {
                this.getItemHandler().setStackInSlot(9, result);
                for (int i = 0; i < 9; ++i) {
                    this.getItemHandler().setStackInSlot(i, ItemStack.EMPTY);
                }
                this.markUpdated();
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean decompress() {
        GenericRecipeInput inputs = new GenericRecipeInput((List<ItemStack>)this.getItemHandler().getAllStacks());
        return this.getLevel().getRecipeManager().getRecipeFor((RecipeType)AoARecipes.INFUSED_PRESS_DECOMPRESSION.type().get(), (RecipeInput)inputs, this.level).map(recipe -> {
            ItemStack result = ((InfusedPressDecompressionRecipe)recipe.value()).assemble(inputs, (HolderLookup.Provider)this.level.registryAccess());
            if (!result.isEmpty()) {
                this.getItemHandler().setStackInSlot(9, ItemStack.EMPTY);
                for (int i = 0; i < 9; ++i) {
                    this.getItemHandler().setStackInSlot(i, result.copy());
                }
                this.markUpdated();
                return true;
            }
            return false;
        }).orElse(false);
    }

    public InfusedPressMenu createMenu(int containerId, final Inventory playerInventory) {
        InfusedPressMenu container = new InfusedPressMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos())){

            protected void clearContainer(Player player, Container container) {
                InfusedPressBlockEntity.this.setItems((NonNullList<ItemStack>)((SimpleContainer)this.getInventory()).getItems());
                InfusedPressBlockEntity.this.setOutput(this.getOutputItem());
                ((SimpleContainer)this.getInventory()).clearContent();
                super.clearContainer(player, container);
            }

            @Override
            public void slotsChanged(Container inventory) {
                if (playerInventory.player.containerMenu == this) {
                    InfusedPressBlockEntity.this.setItems((NonNullList<ItemStack>)((SimpleContainer)this.getInventory()).getItems());
                    InfusedPressBlockEntity.this.setOutput(this.getOutputItem());
                }
                super.slotsChanged(inventory);
            }
        };
        for (int i = 0; i < this.getItemHandler().getSlots(); ++i) {
            ((SimpleContainer)container.getInventory()).setItem(i, this.getItemHandler().getStackInSlot(i));
        }
        return container;
    }

    public static class InfusedPressItemHandler
    extends GenericItemStackHandler {
        InfusedPressItemHandler() {
            super(10);
        }

        public int getSlotLimit(int slot) {
            if (slot == 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 9) {
                return stack.is(AoAItems.COMPRESSED_ITEM);
            }
            return stack.is(AoAItems.COMPRESSED_ITEM) || stack.isStackable();
        }
    }
}

