/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public class BossAltarBlockEntity
extends BlockEntity {
    private EntityType<?> entityType = null;
    private Entity cachedEntity = null;

    public BossAltarBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AoABlockEntities.BOSS_ALTAR.get(), pos, blockState);
    }

    @Nullable
    public EntityType<?> getCurrentEntity() {
        return this.entityType;
    }

    @Nullable
    public Entity getCachedEntity() {
        return this.cachedEntity;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateEntity(@Nullable EntityType<?> entityType) {
        this.entityType = entityType;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag tag = super.getUpdateTag(registryLookup);
        tag.putString("entityType", this.entityType == null ? "" : RegistryUtil.getId(this.entityType).toString());
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        if (tag.contains("entityType")) {
            String entityTypeString = tag.getString("entityType");
            this.entityType = entityTypeString.isEmpty() ? null : AoARegistries.ENTITIES.getEntry((ResourceLocation)ResourceLocation.read((String)entityTypeString).getOrThrow());
            if (this.cachedEntity != null) {
                this.cachedEntity.discard();
            }
            this.cachedEntity = this.entityType == null || this.level == null ? null : this.entityType.create(this.level);
        }
    }
}

