/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.toast;

import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAToastTypes;
import net.tslat.aoa3.common.toast.CustomToastData;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.ToastUtil;

public record ResourceRequirementToastData(AoAResource resource, float value) implements CustomToastData
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceRequirementToastData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(AoARegistries.RESOURCES_REGISTRY_KEY), ResourceRequirementToastData::resource, (StreamCodec)ByteBufCodecs.FLOAT, ResourceRequirementToastData::value, ResourceRequirementToastData::new);

    public CustomToastData.Type<ResourceRequirementToastData> type() {
        return (CustomToastData.Type)AoAToastTypes.RESOURCE_REQUIREMENT.get();
    }

    public static void sendToastPopupTo(ServerPlayer pl, AoAResource resource, float value) {
        new ResourceRequirementToastData(resource, value).sendToPlayer(pl);
    }

    @Override
    public void handleOnClient() {
        ToastUtil.addConfigOptionalToast(() -> ToastUtil.addResourceRequirementToast(this), () -> LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("insufficientResource"), ChatFormatting.RED, new Component[]{this.resource.getName(), Component.literal((String)NumberUtil.roundToNthDecimalPlace(this.value, 2))}));
    }
}

