/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.toast;

import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.custom.AoAToastTypes;
import net.tslat.aoa3.common.toast.CustomToastData;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.ToastUtil;

public record ItemRequirementToastData(Ingredient ingredient) implements CustomToastData
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemRequirementToastData> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemRequirementToastData::ingredient, ItemRequirementToastData::new);

    public CustomToastData.Type<ItemRequirementToastData> type() {
        return (CustomToastData.Type)AoAToastTypes.ITEM_REQUIREMENT.get();
    }

    public static void sendToastPopupTo(ServerPlayer pl, Item item) {
        ItemRequirementToastData.sendToastPopupTo(pl, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static void sendToastPopupTo(ServerPlayer pl, ItemStack stack) {
        ItemRequirementToastData.sendToastPopupTo(pl, Ingredient.of((ItemStack[])new ItemStack[]{stack}));
    }

    public static void sendToastPopupTo(ServerPlayer pl, TagKey<Item> tag) {
        ItemRequirementToastData.sendToastPopupTo(pl, Ingredient.of(tag));
    }

    public static void sendToastPopupTo(ServerPlayer pl, Ingredient ingredient) {
        if (!ingredient.isEmpty()) {
            new ItemRequirementToastData(ingredient).sendToPlayer(pl);
        }
    }

    @Override
    public void handleOnClient() {
        ToastUtil.addConfigOptionalToast(() -> ToastUtil.addItemRequirementToast(this), () -> LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("insufficientItems"), ChatFormatting.RED, this.ingredient.getItems()[0].getHoverName()));
    }
}

