/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.item;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.UnobtainableItems;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.content.item.weapon.thrown.Grenade;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class AoACreativeModeTabs {
    private static final Multimap<ResourceKey<CreativeModeTab>, Supplier<ItemStack>> ITEM_CREATIVE_TABS = MultimapBuilder.hashKeys().arrayListValues().build();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MISC_ITEMS = AoACreativeModeTabs.register("miscellaneous", () -> ((Item)AoAItems.LIMONITE_INGOT.get()).getDefaultInstance(), CreativeModeTabs.SPAWN_EGGS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> FOOD = AoACreativeModeTabs.register("food", () -> ((Item)AoAItems.COOKED_RAINBOWFISH.get()).getDefaultInstance(), MISC_ITEMS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TOOLS = AoACreativeModeTabs.register("tools", () -> ((BasePickaxe)((Object)((Object)AoATools.LIMONITE_PICKAXE.get()))).getDefaultInstance(), FOOD);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ARMOUR = AoACreativeModeTabs.register("armour", () -> ((Item)AoAArmour.ALACRITY_ARMOUR.chestplate.get()).getDefaultInstance(), TOOLS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SWORDS = AoACreativeModeTabs.register("swords", () -> ((Item)AoAWeapons.LIMONITE_SWORD.get()).getDefaultInstance(), ARMOUR);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GREATBLADES = AoACreativeModeTabs.register("greatblades", () -> ((Item)AoAWeapons.BLOODLURKER.get()).getDefaultInstance(), SWORDS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAULS = AoACreativeModeTabs.register("mauls", () -> ((Item)AoAWeapons.HORIZON_MAUL.get()).getDefaultInstance(), GREATBLADES);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GUNS = AoACreativeModeTabs.register("guns", () -> ((Item)AoAWeapons.SQUAD_GUN.get()).getDefaultInstance(), MAULS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CANNONS = AoACreativeModeTabs.register("cannons", () -> ((Item)AoAWeapons.BLAST_CANNON.get()).getDefaultInstance(), GUNS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SHOTGUNS = AoACreativeModeTabs.register("shotguns", () -> ((Item)AoAWeapons.BLAST_BARREL.get()).getDefaultInstance(), CANNONS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SNIPERS = AoACreativeModeTabs.register("snipers", () -> ((Item)AoAWeapons.BOLT_RIFLE.get()).getDefaultInstance(), SHOTGUNS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BLASTERS = AoACreativeModeTabs.register("blasters", () -> ((Item)AoAWeapons.LASER_BLASTER.get()).getDefaultInstance(), SNIPERS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CROSSBOWS = AoACreativeModeTabs.register("crossbows", () -> ((Item)AoAWeapons.LUNAR_CROSSBOW.get()).getDefaultInstance(), BLASTERS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BOWS = AoACreativeModeTabs.register("bows", () -> ((Item)AoAWeapons.SPEED_BOW.get()).getDefaultInstance(), CROSSBOWS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> THROWN_WEAPONS = AoACreativeModeTabs.register("thrown_weapons", () -> ((Grenade)((Object)((Object)AoAWeapons.GRENADE.get()))).getDefaultInstance(), BOWS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> STAVES = AoACreativeModeTabs.register("staves", () -> ((Item)AoAWeapons.CELESTIAL_STAFF.get()).getDefaultInstance(), THROWN_WEAPONS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> VULCANES = AoACreativeModeTabs.register("vulcanes", () -> ((Item)AoAWeapons.VULCANE.get()).getDefaultInstance(), STAVES);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> AMMUNITION = AoACreativeModeTabs.register("ammunition", () -> ((Item)AoAItems.LIMONITE_BULLET.get()).getDefaultInstance(), VULCANES);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GENERATION_BLOCKS = AoACreativeModeTabs.register("worldgen_blocks", () -> ((Block)AoABlocks.LELYETIAN_GRASS.get()).asItem().getDefaultInstance(), AMMUNITION);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> DECORATION_BLOCKS = AoACreativeModeTabs.register("decoration_blocks", () -> AoABlocks.BARON_STONE_BRICKS.stone().asItem().getDefaultInstance(), GENERATION_BLOCKS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> FUNCTIONAL_BLOCKS = AoACreativeModeTabs.register("functional_blocks", () -> ((Block)AoABlocks.SHADOW_ALTAR.get()).asItem().getDefaultInstance(), DECORATION_BLOCKS);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BANNERS = AoACreativeModeTabs.register("banners", () -> AoABlocks.ANCIENT_BANNER.base().asItem().getDefaultInstance(), FUNCTIONAL_BLOCKS);

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, BuildCreativeModeTabContentsEvent.class, AoACreativeModeTabs::fillVanillaTabs);
    }

    private static DeferredHolder<CreativeModeTab, CreativeModeTab> register(String id, Supplier<ItemStack> icon, DeferredHolder<CreativeModeTab, CreativeModeTab> afterTab) {
        return AoACreativeModeTabs.register(id, icon, afterTab.getKey());
    }

    private static DeferredHolder<CreativeModeTab, CreativeModeTab> register(String id, Supplier<ItemStack> icon, ResourceKey<CreativeModeTab> ... afterTabs) {
        return AoARegistries.CREATIVE_MODE_TABS.register(id, () -> CreativeModeTab.builder().title((Component)LocaleUtil.getLocaleMessage("itemGroup.aoa3." + id)).withTabsBefore(afterTabs).icon(icon).displayItems((displayParams, output) -> output.acceptAll(AoACreativeModeTabs.getItemsForTab(AoARegistries.CREATIVE_MODE_TABS.getEntry(AdventOfAscension.id(id))))).build());
    }

    private static void fillVanillaTabs(BuildCreativeModeTabContentsEvent ev) {
        if (!AdventOfAscension.isAoA(ev.getTabKey().location())) {
            ev.acceptAll(AoACreativeModeTabs.getItemsForTab(ev.getTab()));
        }
    }

    public static void setItemCreativeTabs(Supplier<? extends Item> item, Collection<ResourceKey<CreativeModeTab>> creativeTabs) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            creativeTabs.forEach(key -> ITEM_CREATIVE_TABS.put(key, () -> AoACreativeModeTabs.lambda$setItemCreativeTabs$24((Supplier)item)));
        }
    }

    public static void setItemStackCreativeTabs(Supplier<ItemStack> stack, Collection<ResourceKey<CreativeModeTab>> creativeTabs) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            creativeTabs.forEach(key -> ITEM_CREATIVE_TABS.put(key, (Object)stack));
        }
    }

    public static List<ItemStack> getItemsForTab(CreativeModeTab tab) {
        Set unobtainableItems = WorldUtil.getServer() != null || AoAConfigs.CLIENT.hideSurvivalUnobtainableItems.getAsBoolean() ? (Set)UnobtainableItems.CURRENT_SET.get() : Set.of();
        return BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)tab).map(key -> ITEM_CREATIVE_TABS.get(key).stream().map(Supplier::get).filter(stack -> !unobtainableItems.contains(stack.getItem())).toList()).orElse(List.of());
    }

    private static /* synthetic */ ItemStack lambda$setItemCreativeTabs$24(Supplier item) {
        return ((Item)item.get()).getDefaultInstance();
    }
}

