/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity.variant;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.entity.variant.VariantSpawnPredicate;
import net.tslat.aoa3.content.entity.monster.precasia.VeloraptorEntity;
import org.jetbrains.annotations.Nullable;

public record VeloraptorVariant(String name, boolean isPriorityVariant, Optional<ResourceKey<LootTable>> lootTable, VariantSpawnPredicate spawnPredicate) {
    public static final DeferredHolder<VeloraptorVariant, VeloraptorVariant> GREEN = VeloraptorVariant.register("green", () -> new VeloraptorVariant("green", true, Optional.empty(), VariantSpawnPredicate.ALWAYS));
    public static final DeferredHolder<VeloraptorVariant, VeloraptorVariant> BROWN = VeloraptorVariant.register("brown", () -> new VeloraptorVariant("brown", VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.VELORAPTOR_VARIANTS.size())));
    private static final Supplier<VeloraptorVariant[]> SORTED_VARIANTS = Suppliers.memoize(() -> (VeloraptorVariant[])AoARegistries.VELORAPTOR_VARIANTS.getAllRegisteredObjects().filter(variant -> variant != GREEN.get()).sorted(Comparator.comparing(VeloraptorVariant::isPriorityVariant).reversed()).toArray(VeloraptorVariant[]::new));

    public VeloraptorVariant(String name, VariantSpawnPredicate spawnPredicate) {
        this(name, false, Optional.empty(), spawnPredicate);
    }

    public static void init() {
    }

    private static DeferredHolder<VeloraptorVariant, VeloraptorVariant> register(String id, Supplier<VeloraptorVariant> variant) {
        return AoARegistries.VELORAPTOR_VARIANTS.register(id, variant);
    }

    public static VeloraptorVariant getVariantForSpawn(ServerLevel level, DifficultyInstance difficulty, MobSpawnType spawnReason, VeloraptorEntity veloraptor, Supplier<Holder<Biome>> biome, @Nullable SpawnGroupData spawnData) {
        VeloraptorVariant variant = (VeloraptorVariant)GREEN.get();
        for (VeloraptorVariant testVariant : SORTED_VARIANTS.get()) {
            if (!testVariant.spawnPredicate().canSpawnVariant(level, difficulty, spawnReason, (Entity)veloraptor, biome, spawnData)) continue;
            variant = testVariant;
            break;
        }
        return variant;
    }
}

