/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity.variant;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.entity.variant.VariantSpawnPredicate;
import net.tslat.aoa3.content.entity.misc.PixonEntity;

public record PixonVariant(String name, boolean isPriorityVariant, int primaryColour, int secondaryColour, ResourceKey<LootTable> lootTable, VariantSpawnPredicate spawnPredicate) {
    public static final DeferredHolder<PixonVariant, PixonVariant> AMBIENT = PixonVariant.register("ambient", () -> new PixonVariant("ambient", 0x5A5A5A, 0x313131, AdventOfAscension.id("entities/ambient_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> GLISTENING = PixonVariant.register("glistening", () -> new PixonVariant("glistening", 446507, 29958, AdventOfAscension.id("entities/glistening_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> BLOOMING = PixonVariant.register("blooming", () -> new PixonVariant("blooming", 7864543, 2162750, AdventOfAscension.id("entities/blooming_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> SHINING = PixonVariant.register("shining", () -> new PixonVariant("shining", 13963379, 3804713, AdventOfAscension.id("entities/shining_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> GLEAMING = PixonVariant.register("gleaming", () -> new PixonVariant("gleaming", 51158, 28536, AdventOfAscension.id("entities/gleaming_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> GLOWING = PixonVariant.register("glowing", () -> new PixonVariant("glowing", 11693346, 6437907, AdventOfAscension.id("entities/glowing_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> GLARING = PixonVariant.register("glaring", () -> new PixonVariant("glaring", 13644294, 2950144, AdventOfAscension.id("entities/glaring_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    public static final DeferredHolder<PixonVariant, PixonVariant> RADIANT = PixonVariant.register("radiant", () -> new PixonVariant("radiant", 0xCBCBCB, 0x727272, AdventOfAscension.id("entities/radiant_pixon"), VariantSpawnPredicate.randomChance(random -> (double)random.nextFloat() < 0.41)));
    private static final Supplier<PixonVariant[]> SORTED_VARIANTS = Suppliers.memoize(() -> (PixonVariant[])AoARegistries.PIXON_VARIANTS.getAllRegisteredObjects().sorted(Comparator.comparing(PixonVariant::isPriorityVariant).reversed()).toArray(PixonVariant[]::new));

    public PixonVariant(String name, int primaryColour, int secondaryColour, ResourceLocation lootTable, VariantSpawnPredicate spawnPredicate) {
        this(name, false, primaryColour, secondaryColour, (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), spawnPredicate);
    }

    public static void init() {
    }

    private static DeferredHolder<PixonVariant, PixonVariant> register(String id, Supplier<PixonVariant> variant) {
        return AoARegistries.PIXON_VARIANTS.register(id, variant);
    }

    public static PixonVariant getVariantForSpawn(ServerLevel level, DifficultyInstance difficulty, PixonEntity pixon, Supplier<Holder<Biome>> biome) {
        PixonVariant variant = (PixonVariant)AMBIENT.get();
        for (PixonVariant testVariant : SORTED_VARIANTS.get()) {
            if (!testVariant.spawnPredicate().canSpawnVariant(level, difficulty, MobSpawnType.NATURAL, pixon, biome, null)) continue;
            variant = testVariant;
            break;
        }
        return variant;
    }
}

