/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity.variant;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.entity.variant.VariantSpawnPredicate;
import net.tslat.aoa3.content.entity.npc.ambient.DryadSpriteEntity;
import org.jetbrains.annotations.Nullable;

public record DryadSpriteVariant(String name, boolean isPriorityVariant, Ingredient offering, VariantSpawnPredicate spawnPredicate) {
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> WOOD = DryadSpriteVariant.register("wood", () -> new DryadSpriteVariant("wood", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.WOODEN_HOE}), VariantSpawnPredicate.ALWAYS));
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> STONE = DryadSpriteVariant.register("stone", () -> new DryadSpriteVariant("stone", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_HOE}), VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.DRYAD_SPRITE_VARIANTS.size())));
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> IRON = DryadSpriteVariant.register("iron", () -> new DryadSpriteVariant("iron", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_HOE}), VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.DRYAD_SPRITE_VARIANTS.size())));
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> GOLD = DryadSpriteVariant.register("gold", () -> new DryadSpriteVariant("gold", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_HOE}), VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.DRYAD_SPRITE_VARIANTS.size())));
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> DIAMOND = DryadSpriteVariant.register("diamond", () -> new DryadSpriteVariant("diamond", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_HOE}), VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.DRYAD_SPRITE_VARIANTS.size())));
    public static final DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> NETHERITE = DryadSpriteVariant.register("netherite", () -> new DryadSpriteVariant("netherite", true, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_HOE}), VariantSpawnPredicate.randomChance(random -> random.nextFloat() < 1.0f / (float)AoARegistries.DRYAD_SPRITE_VARIANTS.size())));
    private static final Supplier<DryadSpriteVariant[]> SORTED_VARIANTS = Suppliers.memoize(() -> (DryadSpriteVariant[])AoARegistries.DRYAD_SPRITE_VARIANTS.getAllRegisteredObjects().filter(variant -> variant != WOOD.get()).sorted(Comparator.comparing(DryadSpriteVariant::isPriorityVariant).reversed()).toArray(DryadSpriteVariant[]::new));

    public DryadSpriteVariant(String name, Ingredient offering, VariantSpawnPredicate spawnPredicate) {
        this(name, false, offering, spawnPredicate);
    }

    public boolean isCorrectOffering(ItemStack stack) {
        return this.offering.test(stack);
    }

    public static void init() {
    }

    private static DeferredHolder<DryadSpriteVariant, DryadSpriteVariant> register(String id, Supplier<DryadSpriteVariant> variant) {
        return AoARegistries.DRYAD_SPRITE_VARIANTS.register(id, variant);
    }

    public static DryadSpriteVariant getVariantForSpawn(ServerLevel level, DifficultyInstance difficulty, MobSpawnType spawnReason, DryadSpriteEntity dryadSprite, Supplier<Holder<Biome>> biome, @Nullable SpawnGroupData spawnData) {
        DryadSpriteVariant variant = (DryadSpriteVariant)WOOD.get();
        for (DryadSpriteVariant testVariant : SORTED_VARIANTS.get()) {
            if (!testVariant.spawnPredicate().canSpawnVariant(level, difficulty, spawnReason, (Entity)dryadSprite, biome, spawnData)) continue;
            variant = testVariant;
            break;
        }
        return variant;
    }
}

