/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.animal.ShinySquidEntity;
import net.tslat.aoa3.content.entity.animal.barathos.ArkbackEntity;
import net.tslat.aoa3.content.entity.animal.barathos.EmperorBeastEntity;
import net.tslat.aoa3.content.entity.animal.fish.BasicFishEntity;
import net.tslat.aoa3.content.entity.animal.fish.BasicLavaFishEntity;
import net.tslat.aoa3.content.entity.animal.precasia.DeinotheriumEntity;
import net.tslat.aoa3.content.entity.animal.precasia.HorndronEntity;
import net.tslat.aoa3.content.entity.animal.precasia.OpteryxEntity;
import net.tslat.aoa3.content.entity.boss.king_bambambam.EliteKingBamBamBamEntity;
import net.tslat.aoa3.content.entity.boss.king_bambambam.KingBamBamBamEntity;
import net.tslat.aoa3.content.entity.boss.nethengeic_wither.EliteNethengeicWitherEntity;
import net.tslat.aoa3.content.entity.boss.nethengeic_wither.NethengeicWitherEntity;
import net.tslat.aoa3.content.entity.boss.skeletron.EliteSkeletronEntity;
import net.tslat.aoa3.content.entity.boss.skeletron.SkeletronEntity;
import net.tslat.aoa3.content.entity.boss.smash.EliteSmashEntity;
import net.tslat.aoa3.content.entity.boss.smash.SmashEntity;
import net.tslat.aoa3.content.entity.boss.tyrosaur.EliteTyrosaurEntity;
import net.tslat.aoa3.content.entity.boss.tyrosaur.TyrosaurEntity;
import net.tslat.aoa3.content.entity.boss.tyrosaur.WoundedTyrosaurEntity;
import net.tslat.aoa3.content.entity.monster.barathos.NospikeEntity;
import net.tslat.aoa3.content.entity.monster.barathos.TharaflyEntity;
import net.tslat.aoa3.content.entity.monster.misc.ThornyPlantSproutEntity;
import net.tslat.aoa3.content.entity.monster.nether.EmbrakeEntity;
import net.tslat.aoa3.content.entity.monster.nether.FlamewalkerEntity;
import net.tslat.aoa3.content.entity.monster.nether.InfernalEntity;
import net.tslat.aoa3.content.entity.monster.nether.LittleBamEntity;
import net.tslat.aoa3.content.entity.monster.nether.NethengeicBeastEntity;
import net.tslat.aoa3.content.entity.monster.overworld.AncientGolemEntity;
import net.tslat.aoa3.content.entity.monster.overworld.BombCarrierEntity;
import net.tslat.aoa3.content.entity.monster.overworld.BushBabyEntity;
import net.tslat.aoa3.content.entity.monster.overworld.ChargerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.ChomperEntity;
import net.tslat.aoa3.content.entity.monster.overworld.CyclopsEntity;
import net.tslat.aoa3.content.entity.monster.overworld.GhostEntity;
import net.tslat.aoa3.content.entity.monster.overworld.GoblinEntity;
import net.tslat.aoa3.content.entity.monster.overworld.IceGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.KingChargerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.LeafyGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.SandGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.SasquatchEntity;
import net.tslat.aoa3.content.entity.monster.overworld.StoneGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.TreeSpiritEntity;
import net.tslat.aoa3.content.entity.monster.overworld.VoidWalkerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.WoodGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.YetiEntity;
import net.tslat.aoa3.content.entity.monster.precasia.AttercopusEntity;
import net.tslat.aoa3.content.entity.monster.precasia.DunkleosteusEntity;
import net.tslat.aoa3.content.entity.monster.precasia.MeganeuropsisEntity;
import net.tslat.aoa3.content.entity.monster.precasia.ScolopendisEntity;
import net.tslat.aoa3.content.entity.monster.precasia.SkeletalAbominationEntity;
import net.tslat.aoa3.content.entity.monster.precasia.SmilodonEntity;
import net.tslat.aoa3.content.entity.monster.precasia.SpinoledonEntity;
import net.tslat.aoa3.content.entity.monster.precasia.VeloraptorEntity;
import net.tslat.aoa3.content.entity.npc.ambient.DryadSpriteEntity;
import net.tslat.aoa3.content.entity.npc.trader.CorruptedTravellerEntity;
import net.tslat.aoa3.content.entity.npc.trader.LottomanEntity;
import net.tslat.aoa3.content.entity.npc.trader.SkillMasterEntity;
import net.tslat.aoa3.content.entity.npc.trader.UndeadHeraldEntity;

public final class AoAEntityStats {
    public static void init() {
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, EntityAttributeCreationEvent.class, AoAEntityStats::registerStats);
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, EntityAttributeModificationEvent.class, AoAEntityStats::modifyStats);
    }

    private static void modifyStats(EntityAttributeModificationEvent ev) {
        ev.add(EntityType.PLAYER, AoAAttributes.CRITICAL_HIT_MULTIPLIER);
    }

    private static void registerStats(EntityAttributeCreationEvent ev) {
        AoAEntityStats.doOverworldEntityStats(ev);
        AoAEntityStats.doNetherEntityStats(ev);
        AoAEntityStats.doPrecasiaEntityStats(ev);
        AoAEntityStats.doBarathosEntityStats(ev);
        AoAEntityStats.doBossEntityStats(ev);
        AoAEntityStats.doNpcEntityStats(ev);
        AoAEntityStats.doMiscEntityStats(ev);
    }

    private static void doOverworldEntityStats(EntityAttributeCreationEvent ev) {
        AncientGolemEntity.entityStats((EntityType<AncientGolemEntity>)((EntityType)AoAMonsters.ANCIENT_GOLEM.get())).build(ev);
        BombCarrierEntity.entityStats((EntityType<BombCarrierEntity>)((EntityType)AoAMonsters.BOMB_CARRIER.get())).build(ev);
        BushBabyEntity.entityStats((EntityType<BushBabyEntity>)((EntityType)AoAMonsters.BUSH_BABY.get())).build(ev);
        ChargerEntity.entityStats((EntityType<ChargerEntity>)((EntityType)AoAMonsters.CHARGER.get())).build(ev);
        ChomperEntity.entityStats((EntityType<ChomperEntity>)((EntityType)AoAMonsters.CHOMPER.get())).build(ev);
        CyclopsEntity.entityStats((EntityType<CyclopsEntity>)((EntityType)AoAMonsters.CYCLOPS.get())).build(ev);
        GhostEntity.entityStats((EntityType<GhostEntity>)((EntityType)AoAMonsters.GHOST.get())).build(ev);
        GoblinEntity.entityStats((EntityType<GoblinEntity>)((EntityType)AoAMonsters.GOBLIN.get())).build(ev);
        SasquatchEntity.entityStats((EntityType<SasquatchEntity>)((EntityType)AoAMonsters.SASQUATCH.get())).build(ev);
        TreeSpiritEntity.entityStats((EntityType<TreeSpiritEntity>)((EntityType)AoAMonsters.TREE_SPIRIT.get())).build(ev);
        VoidWalkerEntity.entityStats((EntityType<VoidWalkerEntity>)((EntityType)AoAMonsters.VOID_WALKER.get())).build(ev);
        YetiEntity.entityStats((EntityType<YetiEntity>)((EntityType)AoAMonsters.YETI.get())).build(ev);
        KingChargerEntity.entityStats((EntityType<KingChargerEntity>)((EntityType)AoAMonsters.KING_CHARGER.get())).build(ev);
        IceGiantEntity.entityStats((EntityType<IceGiantEntity>)((EntityType)AoAMonsters.ICE_GIANT.get())).build(ev);
        LeafyGiantEntity.entityStats((EntityType<LeafyGiantEntity>)((EntityType)AoAMonsters.LEAFY_GIANT.get())).build(ev);
        SandGiantEntity.entityStats((EntityType<SandGiantEntity>)((EntityType)AoAMonsters.SAND_GIANT.get())).build(ev);
        StoneGiantEntity.entityStats((EntityType<StoneGiantEntity>)((EntityType)AoAMonsters.STONE_GIANT.get())).build(ev);
        WoodGiantEntity.entityStats((EntityType<WoodGiantEntity>)((EntityType)AoAMonsters.WOOD_GIANT.get())).build(ev);
    }

    private static void doNetherEntityStats(EntityAttributeCreationEvent ev) {
        EmbrakeEntity.entityStats((EntityType<EmbrakeEntity>)((EntityType)AoAMonsters.EMBRAKE.get())).build(ev);
        FlamewalkerEntity.entityStats((EntityType<FlamewalkerEntity>)((EntityType)AoAMonsters.FLAMEWALKER.get())).build(ev);
        LittleBamEntity.entityStats((EntityType<LittleBamEntity>)((EntityType)AoAMonsters.LITTLE_BAM.get())).build(ev);
        NethengeicBeastEntity.entityStats((EntityType<NethengeicBeastEntity>)((EntityType)AoAMonsters.NETHENGEIC_BEAST.get())).build(ev);
        InfernalEntity.entityStats((EntityType<InfernalEntity>)((EntityType)AoAMonsters.INFERNAL.get())).build(ev);
    }

    private static void doPrecasiaEntityStats(EntityAttributeCreationEvent ev) {
        HorndronEntity.entityStats((EntityType<HorndronEntity>)((EntityType)AoAAnimals.HORNDRON.get())).build(ev);
        DeinotheriumEntity.entityStats((EntityType<DeinotheriumEntity>)((EntityType)AoAAnimals.DEINOTHERIUM.get())).build(ev);
        OpteryxEntity.entityStats((EntityType<OpteryxEntity>)((EntityType)AoAAnimals.OPTERYX.get())).build(ev);
        SpinoledonEntity.entityStats((EntityType<SpinoledonEntity>)((EntityType)AoAMonsters.SPINOLEDON.get())).build(ev);
        MeganeuropsisEntity.entityStats((EntityType<MeganeuropsisEntity>)((EntityType)AoAMonsters.MEGANEUROPSIS.get())).build(ev);
        ScolopendisEntity.entityStats((EntityType<ScolopendisEntity>)((EntityType)AoAMonsters.SCOLOPENDIS.get())).build(ev);
        DunkleosteusEntity.entityStats((EntityType<DunkleosteusEntity>)((EntityType)AoAMonsters.DUNKLEOSTEUS.get())).build(ev);
        AttercopusEntity.entityStats((EntityType<AttercopusEntity>)((EntityType)AoAMonsters.ATTERCOPUS.get())).build(ev);
        SmilodonEntity.entityStats((EntityType<SmilodonEntity>)((EntityType)AoAMonsters.SMILODON.get())).build(ev);
        SkeletalAbominationEntity.entityStats((EntityType<SkeletalAbominationEntity>)((EntityType)AoAMonsters.SKELETAL_ABOMINATION.get())).build(ev);
        VeloraptorEntity.entityStats((EntityType<VeloraptorEntity>)((EntityType)AoAMonsters.VELORAPTOR.get())).build(ev);
    }

    private static void doBarathosEntityStats(EntityAttributeCreationEvent ev) {
        NospikeEntity.entityStats((EntityType<NospikeEntity>)((EntityType)AoAMonsters.NOSPIKE.get())).build(ev);
        TharaflyEntity.entityStats((EntityType<TharaflyEntity>)((EntityType)AoAMonsters.THARAFLY.get())).build(ev);
        ArkbackEntity.entityStats((EntityType<ArkbackEntity>)((EntityType)AoAAnimals.ARKBACK.get())).build(ev);
        EmperorBeastEntity.entityStats((EntityType<EmperorBeastEntity>)((EntityType)AoAAnimals.EMPEROR_BEAST.get())).build(ev);
    }

    private static void doBossEntityStats(EntityAttributeCreationEvent ev) {
        WoundedTyrosaurEntity.entityStats((EntityType<WoundedTyrosaurEntity>)((EntityType)AoAMonsters.WOUNDED_TYROSAUR.get())).build(ev);
        SmashEntity.entityStats((EntityType<SmashEntity>)((EntityType)AoAMonsters.SMASH.get())).build(ev);
        EliteSmashEntity.entityStats((EntityType<EliteSmashEntity>)((EntityType)AoAMonsters.ELITE_SMASH.get())).build(ev);
        NethengeicWitherEntity.entityStats((EntityType<NethengeicWitherEntity>)((EntityType)AoAMonsters.NETHENGEIC_WITHER.get())).build(ev);
        EliteNethengeicWitherEntity.entityStats((EntityType<EliteNethengeicWitherEntity>)((EntityType)AoAMonsters.ELITE_NETHENGEIC_WITHER.get())).build(ev);
        KingBamBamBamEntity.entityStats((EntityType<KingBamBamBamEntity>)((EntityType)AoAMonsters.KING_BAMBAMBAM.get())).build(ev);
        EliteKingBamBamBamEntity.entityStats((EntityType<EliteKingBamBamBamEntity>)((EntityType)AoAMonsters.ELITE_KING_BAMBAMBAM.get())).build(ev);
        TyrosaurEntity.entityStats((EntityType<TyrosaurEntity>)((EntityType)AoAMonsters.TYROSAUR.get())).build(ev);
        EliteTyrosaurEntity.entityStats((EntityType<EliteTyrosaurEntity>)((EntityType)AoAMonsters.ELITE_TYROSAUR.get())).build(ev);
        SkeletronEntity.entityStats((EntityType<SkeletronEntity>)((EntityType)AoAMonsters.SKELETRON.get())).build(ev);
        EliteSkeletronEntity.entityStats((EntityType<EliteSkeletronEntity>)((EntityType)AoAMonsters.ELITE_SKELETRON.get())).build(ev);
    }

    private static void doNpcEntityStats(EntityAttributeCreationEvent ev) {
        SkillMasterEntity.entityStats((EntityType<SkillMasterEntity>)((EntityType)AoANpcs.SKILL_MASTER.get())).build(ev);
        CorruptedTravellerEntity.entityStats((EntityType<CorruptedTravellerEntity>)((EntityType)AoANpcs.CORRUPTED_TRAVELLER.get())).build(ev);
        LottomanEntity.entityStats((EntityType<LottomanEntity>)((EntityType)AoANpcs.LOTTOMAN.get())).build(ev);
        UndeadHeraldEntity.entityStats((EntityType<UndeadHeraldEntity>)((EntityType)AoANpcs.UNDEAD_HERALD.get())).build(ev);
    }

    private static void doMiscEntityStats(EntityAttributeCreationEvent ev) {
        ThornyPlantSproutEntity.entityStats((EntityType<ThornyPlantSproutEntity>)((EntityType)AoAMiscEntities.THORNY_PLANT_SPROUT.get())).build(ev);
        DryadSpriteEntity.entityStats((EntityType<DryadSpriteEntity>)((EntityType)AoANpcs.DRYAD_SPRITE.get())).build(ev);
        ShinySquidEntity.entityStats((EntityType<ShinySquidEntity>)((EntityType)AoAAnimals.SHINY_SQUID.get())).build(ev);
        BasicLavaFishEntity.entityStats((EntityType<BasicLavaFishEntity>)((EntityType)AoAAnimals.CANDLEFISH.get())).build(ev);
        BasicLavaFishEntity.entityStats((EntityType<BasicLavaFishEntity>)((EntityType)AoAAnimals.CHARRED_CHAR.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.CHOCAW.get())).build(ev);
        BasicLavaFishEntity.entityStats((EntityType<BasicLavaFishEntity>)((EntityType)AoAAnimals.CRIMSON_SKIPPER.get())).build(ev);
        BasicLavaFishEntity.entityStats((EntityType<BasicLavaFishEntity>)((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.DARK_HATCHETFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.BLUE_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.GREEN_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.PURPLE_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.RED_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.WHITE_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.YELLOW_GEMTRAP.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.HYDRONE.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.IRONBACK.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.JAMFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.PARAPIRANHA.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.PEARL_STRIPEFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.RAINBOWFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.RAZORFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.REEFTOOTH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.ROCKETFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.SAILBACK.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.SKELECANTH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get())).build(ev);
        BasicFishEntity.entityStats((EntityType<BasicFishEntity>)((EntityType)AoAAnimals.VIOLET_SKIPPER.get())).build(ev);
    }

    public record AttributeBuilder(EntityType<? extends LivingEntity> entityType, AttributeSupplier.Builder attributeMap) {
        public static AttributeBuilder create(EntityType<? extends LivingEntity> entityType) {
            return new AttributeBuilder(entityType, Mob.createMobAttributes());
        }

        public static AttributeBuilder createMonster(EntityType<? extends Mob> entityType) {
            return AttributeBuilder.create(entityType).meleeStrength(0.0).extraAttributes(new Holder[]{AoAAttributes.AGGRO_RANGE});
        }

        public AttributeBuilder armour(double armour) {
            this.attributeMap.add(Attributes.ARMOR, armour);
            return this;
        }

        public AttributeBuilder armour(double armour, double toughness) {
            this.attributeMap.add(Attributes.ARMOR, armour);
            this.attributeMap.add(Attributes.ARMOR_TOUGHNESS, toughness);
            return this;
        }

        public AttributeBuilder meleeStrength(double strength) {
            this.attributeMap.add(Attributes.ATTACK_DAMAGE, strength);
            return this;
        }

        public AttributeBuilder knockback(double knockbackStrength) {
            this.attributeMap.add(Attributes.ATTACK_KNOCKBACK, knockbackStrength);
            return this;
        }

        public AttributeBuilder meleeSpeed(double speed) {
            this.attributeMap.add(Attributes.ATTACK_SPEED, speed);
            return this;
        }

        public AttributeBuilder burnTimeMultiplier(double multiplier) {
            this.attributeMap.add(Attributes.BURNING_TIME, multiplier);
            return this;
        }

        public AttributeBuilder explosionKnockbackResist(double resistance) {
            this.attributeMap.add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, resistance);
            return this;
        }

        public AttributeBuilder fallDamageMultiplier(double multiplier) {
            this.attributeMap.add(Attributes.FALL_DAMAGE_MULTIPLIER, multiplier);
            return this;
        }

        public AttributeBuilder flyingSpeed(double flyingSpeed) {
            this.attributeMap.add(Attributes.FLYING_SPEED, flyingSpeed);
            return this;
        }

        public AttributeBuilder followRange(double distance) {
            this.attributeMap.add(Attributes.FOLLOW_RANGE, distance);
            return this;
        }

        public AttributeBuilder gravity(double gravity) {
            this.attributeMap.add(Attributes.GRAVITY, gravity);
            return this;
        }

        public AttributeBuilder jumpStrength(double strength) {
            this.attributeMap.add(Attributes.JUMP_STRENGTH, strength);
            return this;
        }

        public AttributeBuilder knockbackResist(double resistance) {
            this.attributeMap.add(Attributes.KNOCKBACK_RESISTANCE, resistance);
            if (!this.attributeMap.hasAttribute(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE)) {
                this.attributeMap.add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, resistance);
            }
            return this;
        }

        public AttributeBuilder health(double health) {
            this.attributeMap.add(Attributes.MAX_HEALTH, health);
            return this;
        }

        public AttributeBuilder moveSpeed(double speed) {
            this.attributeMap.add(Attributes.MOVEMENT_SPEED, speed);
            return this;
        }

        public AttributeBuilder safeFallDistance(double blocks) {
            this.attributeMap.add(Attributes.SAFE_FALL_DISTANCE, blocks);
            return this;
        }

        public AttributeBuilder reinforcementsChance(double chance) {
            this.attributeMap.add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, chance);
            return this;
        }

        public AttributeBuilder stepHeight(double stepHeight) {
            this.attributeMap.add(Attributes.STEP_HEIGHT, stepHeight);
            return this;
        }

        public AttributeBuilder swimSpeedMod(double speed) {
            this.attributeMap.add(NeoForgeMod.SWIM_SPEED, speed);
            return this;
        }

        public AttributeBuilder nametagDistance(double distance) {
            this.attributeMap.add(NeoForgeMod.NAMETAG_DISTANCE, distance);
            return this;
        }

        public AttributeBuilder aggroRange(double distance) {
            this.attributeMap.add(AoAAttributes.AGGRO_RANGE, distance);
            return this;
        }

        public AttributeBuilder projectileDamage(double strength) {
            this.attributeMap.add(AoAAttributes.RANGED_ATTACK_DAMAGE, strength);
            return this;
        }

        public AttributeBuilder extraAttributes(Holder<Attribute> ... attributes) {
            for (Holder<Attribute> attribute : attributes) {
                if (this.attributeMap.hasAttribute(attribute)) continue;
                this.attributeMap.add(attribute);
            }
            return this;
        }

        private void build(EntityAttributeCreationEvent ev) {
            ev.put(this.entityType, this.attributeMap.build());
        }
    }
}

