/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.block.group;

import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.tslat.aoa3.common.registration.block.BlockRegistrar;
import net.tslat.aoa3.common.registration.block.group.BlockRegistrarFactory;
import net.tslat.aoa3.content.block.generation.log.LogBlock;

public final class LogBlockGroup {
    public final DeferredBlock<LogBlock> log;
    public final DeferredBlock<LogBlock> bark;
    public final DeferredBlock<LogBlock> strippedLog;
    public final DeferredBlock<LogBlock> strippedBark;

    public LogBlockGroup(String baseId, BlockRegistrarFactory registry, MapColor endColour, MapColor sideColour, LogBuilder logBuilder) {
        this.log = registry.register(baseId + "_log", registrar -> logBuilder.build((BlockRegistrar<? extends Block>)registrar, this::strippedLog, endColour, sideColour));
        this.bark = registry.register(baseId + "_wood", registrar -> registrar.basedOn(this.log).mapColour(sideColour).factory(properties -> new LogBlock((BlockBehaviour.Properties)properties, this::strippedBark)).generationBlocksTab());
        this.strippedLog = registry.register("stripped_" + baseId + "_log", registrar -> registrar.basedOn(this.log).mapColour(endColour).factory(properties -> new LogBlock((BlockBehaviour.Properties)properties, null)).generationBlocksTab());
        this.strippedBark = registry.register("stripped_" + baseId + "_wood", registrar -> registrar.basedOn(this.log).mapColour(endColour).factory(properties -> new LogBlock((BlockBehaviour.Properties)properties, null)).generationBlocksTab());
    }

    public LogBlock log() {
        return (LogBlock)((Object)this.log.get());
    }

    public LogBlock bark() {
        return (LogBlock)((Object)this.bark.get());
    }

    public LogBlock strippedLog() {
        return (LogBlock)((Object)this.strippedLog.get());
    }

    public LogBlock strippedBark() {
        return (LogBlock)((Object)this.strippedBark.get());
    }

    @FunctionalInterface
    public static interface LogBuilder {
        public void build(BlockRegistrar<? extends Block> var1, Supplier<? extends Block> var2, MapColor var3, MapColor var4);
    }
}

