/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.io.File;
import java.io.IOException;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.config.ClientConfig;
import net.tslat.aoa3.config.IntegrationsConfig;
import net.tslat.aoa3.config.ServerConfig;
import net.tslat.aoa3.util.ObjectUtil;
import org.apache.commons.lang3.tuple.Pair;

public final class AoAConfigs {
    public static final ClientConfig CLIENT;
    public static final ModConfigSpec CLIENT_CONFIG_SPEC;
    public static final ServerConfig SERVER;
    public static final ModConfigSpec SERVER_CONFIG_SPEC;
    public static final IntegrationsConfig INTEGRATIONS;
    public static final ModConfigSpec INTEGRATIONS_CONFIG_SPEC;

    public static void init(ModContainer modContainer) {
        try {
            ObjectUtil.getOrCreateDirectory(FMLPaths.CONFIGDIR.get().resolve("aoa3"), "aoa3");
            modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG_SPEC, "aoa3_server_config.toml");
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG_SPEC, "aoa3" + File.separator + "client_config.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)INTEGRATIONS_CONFIG_SPEC, "aoa3" + File.separator + "integrations_config.toml");
        }
        catch (IOException ex) {
            Logging.error("Failed to create config directories.. this is not good", ex);
        }
    }

    static {
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        Pair serverSpecPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        Pair integrationSpecPair = new ModConfigSpec.Builder().configure(IntegrationsConfig::new);
        CLIENT_CONFIG_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        SERVER_CONFIG_SPEC = (ModConfigSpec)serverSpecPair.getRight();
        SERVER = (ServerConfig)serverSpecPair.getLeft();
        INTEGRATIONS_CONFIG_SPEC = (ModConfigSpec)integrationSpecPair.getRight();
        INTEGRATIONS = (IntegrationsConfig)integrationSpecPair.getLeft();
    }
}

