/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.skill.AoASkill;

public record XpGainPacket(ResourceLocation skill, float xp, boolean levelUp) implements AoAPacket
{
    public static final CustomPacketPayload.Type<XpGainPacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("xp_gain"));
    public static final StreamCodec<RegistryFriendlyByteBuf, XpGainPacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, XpGainPacket::skill, (StreamCodec)ByteBufCodecs.FLOAT, XpGainPacket::xp, (StreamCodec)ByteBufCodecs.BOOL, XpGainPacket::levelUp, XpGainPacket::new);

    public CustomPacketPayload.Type<? extends XpGainPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        AoASkill skill;
        if (((Boolean)AoAConfigs.CLIENT.showXpParticles.get()).booleanValue() && (skill = AoASkills.getSkill(this.skill)) != null) {
            XpParticlesRenderer.addXpParticle(skill, this.xp, this.levelUp);
        }
    }
}

