/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.util.CodecUtil;
import org.apache.commons.lang3.tuple.Triple;

public record WorldEventSyncPacket(List<Triple<AoAWorldEvent.Type<?>, ResourceLocation, CompoundTag>> events) implements AoAPacket
{
    public static final CustomPacketPayload.Type<WorldEventSyncPacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("world_event_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WorldEventSyncPacket> CODEC = StreamCodec.composite((StreamCodec)CodecUtil.streamTriple(Triple::of, ByteBufCodecs.registry(AoARegistries.WORLD_EVENT_TYPE_REGISTRY_KEY), ResourceLocation.STREAM_CODEC, ByteBufCodecs.TRUSTED_COMPOUND_TAG).apply(ByteBufCodecs.list()), WorldEventSyncPacket::events, WorldEventSyncPacket::new);

    public CustomPacketPayload.Type<? extends WorldEventSyncPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        context.enqueueWork(() -> AoAWorldEventManager.syncFromServer(this.events));
    }
}

