/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.networking.packets.AddSkillCyclePacket;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.networking.packets.GunRecoilPacket;
import net.tslat.aoa3.common.networking.packets.HaloChangePacket;
import net.tslat.aoa3.common.networking.packets.HaloSelectPacket;
import net.tslat.aoa3.common.networking.packets.MultipartTogglePacket;
import net.tslat.aoa3.common.networking.packets.ParticleEffectPacket;
import net.tslat.aoa3.common.networking.packets.ScreenEffectPacket;
import net.tslat.aoa3.common.networking.packets.ScreenShakePacket;
import net.tslat.aoa3.common.networking.packets.SyncHaloDataPacket;
import net.tslat.aoa3.common.networking.packets.ToastPopupPacket;
import net.tslat.aoa3.common.networking.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.networking.packets.WikiSearchPacket;
import net.tslat.aoa3.common.networking.packets.WorldEventSyncPacket;
import net.tslat.aoa3.common.networking.packets.WorldEventUpdatePacket;
import net.tslat.aoa3.common.networking.packets.XpGainPacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerAbilityKeybindTriggerPacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerDataSyncPacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerDataUpdatePacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.SyncAoAAbilityDataPacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.ToggleAoAAbilityPacket;
import net.tslat.aoa3.common.networking.packets.patchouli.AccountPatchouliBookPacket;
import net.tslat.aoa3.common.networking.packets.patchouli.GivePatchouliBookPacket;
import net.tslat.aoa3.common.networking.packets.patchouli.PatchouliBookSyncPacket;
import net.tslat.aoa3.common.networking.packets.setup.PlayerHalosLoginSyncPacket;
import net.tslat.aoa3.common.networking.packets.setup.SkillReqLoginSyncPacket;

public class AoANetworking {
    public static void init() {
        AdventOfAscension.getModEventBus().addListener(AoANetworking::registerPackets);
    }

    private static void registerPackets(RegisterPayloadHandlersEvent ev) {
        PayloadRegistrar registrar = ev.registrar("aoa3");
        registrar.configurationBidirectional(PlayerHalosLoginSyncPacket.TYPE, PlayerHalosLoginSyncPacket.CODEC, PlayerHalosLoginSyncPacket::receiveMessage);
        registrar.configurationBidirectional(SkillReqLoginSyncPacket.TYPE, SkillReqLoginSyncPacket.CODEC, SkillReqLoginSyncPacket::receiveMessage);
        registrar.playToServer(PlayerAbilityKeybindTriggerPacket.TYPE, PlayerAbilityKeybindTriggerPacket.CODEC, PlayerAbilityKeybindTriggerPacket::receiveMessage);
        registrar.playToServer(ToggleAoAAbilityPacket.TYPE, ToggleAoAAbilityPacket.CODEC, ToggleAoAAbilityPacket::receiveMessage);
        registrar.playToServer(HaloSelectPacket.TYPE, HaloSelectPacket.CODEC, HaloSelectPacket::receiveMessage);
        registrar.playToServer(AccountPatchouliBookPacket.TYPE, AccountPatchouliBookPacket.CODEC, AccountPatchouliBookPacket::receiveMessage);
        registrar.playToServer(GivePatchouliBookPacket.TYPE, GivePatchouliBookPacket.CODEC, GivePatchouliBookPacket::receiveMessage);
        registrar.playToServer(AddSkillCyclePacket.TYPE, AddSkillCyclePacket.CODEC, AddSkillCyclePacket::receiveMessage);
        registrar.playToServer(ParticleEffectPacket.TYPE, ParticleEffectPacket.CODEC, ParticleEffectPacket::receiveMessage);
        registrar.playToServer(SyncAoAAbilityDataPacket.TYPE, SyncAoAAbilityDataPacket.CODEC, SyncAoAAbilityDataPacket::receiveMessage);
        registrar.playToClient(PlayerDataSyncPacket.TYPE, PlayerDataSyncPacket.CODEC, PlayerDataSyncPacket::receiveMessage);
        registrar.playToClient(PlayerDataUpdatePacket.TYPE, PlayerDataUpdatePacket.CODEC, PlayerDataUpdatePacket::receiveMessage);
        registrar.playToClient(ToastPopupPacket.TYPE, ToastPopupPacket.CODEC, ToastPopupPacket::receiveMessage);
        registrar.playToClient(ScreenEffectPacket.TYPE, ScreenEffectPacket.CODEC, ScreenEffectPacket::receiveMessage);
        registrar.playToClient(GunRecoilPacket.TYPE, GunRecoilPacket.CODEC, GunRecoilPacket::receiveMessage);
        registrar.playToClient(ScreenShakePacket.TYPE, ScreenShakePacket.CODEC, ScreenShakePacket::receiveMessage);
        registrar.playToClient(XpGainPacket.TYPE, XpGainPacket.CODEC, XpGainPacket::receiveMessage);
        registrar.playToClient(SyncHaloDataPacket.TYPE, SyncHaloDataPacket.CODEC, SyncHaloDataPacket::receiveMessage);
        registrar.playToClient(WikiSearchPacket.TYPE, WikiSearchPacket.CODEC, WikiSearchPacket::receiveMessage);
        registrar.playToClient(PatchouliBookSyncPacket.TYPE, PatchouliBookSyncPacket.CODEC, PatchouliBookSyncPacket::receiveMessage);
        registrar.playToClient(UpdateClientMovementPacket.TYPE, UpdateClientMovementPacket.CODEC, UpdateClientMovementPacket::receiveMessage);
        registrar.playToClient(AoASoundBuilderPacket.TYPE, AoASoundBuilderPacket.CODEC, AoASoundBuilderPacket::receiveMessage);
        registrar.playToClient(MultipartTogglePacket.TYPE, MultipartTogglePacket.CODEC, MultipartTogglePacket::receiveMessage);
        registrar.playToClient(HaloChangePacket.TYPE, HaloChangePacket.CODEC, HaloChangePacket::receiveMessage);
        registrar.playToClient(WorldEventSyncPacket.TYPE, WorldEventSyncPacket.CODEC, WorldEventSyncPacket::receiveMessage);
        registrar.playToClient(WorldEventUpdatePacket.TYPE, WorldEventUpdatePacket.CODEC, WorldEventUpdatePacket::receiveMessage);
    }

    public static void sendToAllNearbyPlayers(AoAPacket packet, ServerLevel level, Vec3 origin, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)origin.x, (double)origin.y, (double)origin.z, (double)radius, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, AoAPacket packet) {
        if (player.connection != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToAllPlayers(AoAPacket packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(AoAPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllInLevel(ServerLevel level, AoAPacket packet) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllPlayersTrackingBlock(ServerLevel level, BlockPos pos, AoAPacket packet) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllPlayersTrackingEntity(AoAPacket packet, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            AoANetworking.sendToPlayer(pl, packet);
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

