/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu.slot;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;

public abstract class OutputSlot
extends Slot {
    protected final Player player;
    protected int removedCount;

    public OutputSlot(Container inventoryContainer, Player player, int slotIndex, int x, int y) {
        super(inventoryContainer, slotIndex, x, y);
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public boolean mayPickup(Player player) {
        return this.hasItem();
    }

    public ItemStack remove(int amount) {
        this.onRemove(amount);
        return super.remove(amount);
    }

    public void onRemove(int amount) {
        if (this.hasItem()) {
            this.removedCount += Math.min(amount, this.getItem().getCount());
        }
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removedCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int amount) {
        this.removedCount += amount;
    }

    public void onTake(Player player, ItemStack stack) {
        this.onItemRemoved(player, stack);
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    public abstract void onItemRemoved(Player var1, ItemStack var2);

    protected void checkTakeAchievements(ItemStack stack) {
        if (this.removedCount > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.removedCount);
            EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.container);
        }
        this.removedCount = 0;
    }
}

