/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu.slot;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.menu.slot.OutputSlot;
import org.jetbrains.annotations.Nullable;

public class CraftableResultSlot<C extends Container, I extends RecipeInput, R extends Recipe<I>>
extends OutputSlot {
    private final C inventoryContainer;
    private final RecipeCraftingHolder resultContainer;
    @Nullable
    private final RecipeType<R> recipeType;
    private final Supplier<I> recipeInput;

    public <T extends Container & RecipeCraftingHolder> CraftableResultSlot(Player player, C inventoryContainer, T resultContainer, @Nullable RecipeType<R> recipeType, Supplier<I> recipeInput, int slotIndex, int x, int y) {
        super(resultContainer, player, slotIndex, x, y);
        this.recipeType = recipeType;
        this.inventoryContainer = inventoryContainer;
        this.resultContainer = resultContainer;
        this.recipeInput = recipeInput;
    }

    public RecipeCraftingHolder getResultContainer() {
        return this.resultContainer;
    }

    public Optional<R> getCurrentRecipe() {
        return Optional.ofNullable(this.getResultContainer().getRecipeUsed()).map(RecipeHolder::value);
    }

    public C getInventoryContainer() {
        return this.inventoryContainer;
    }

    @Override
    protected void checkTakeAchievements(ItemStack stack) {
        if (this.removedCount > 0) {
            this.awardForCrafting(stack, this.removedCount);
        }
        this.getResultContainer().awardUsedRecipes(this.player, this.getContainerItems());
    }

    protected List<ItemStack> getContainerItems() {
        Container container = this.container;
        if (container instanceof CraftingContainer) {
            CraftingContainer craftingContainer = (CraftingContainer)container;
            return craftingContainer.getItems();
        }
        container = this.container;
        if (container instanceof SimpleContainer) {
            SimpleContainer simpleContainer = (SimpleContainer)container;
            return simpleContainer.getItems();
        }
        ObjectArrayList items = new ObjectArrayList(this.container.getContainerSize());
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            items.add(this.container.getItem(i));
        }
        return items;
    }

    protected void awardForCrafting(ItemStack stack, int amount) {
        stack.onCraftedBy(this.player.level(), this.player, this.removedCount);
        EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, this.inventoryContainer);
    }

    protected NonNullList<ItemStack> getRemainingItems(@Nullable RecipeType<R> recipeType, I recipeInput, Player player) {
        return recipeType == null ? NonNullList.createWithCapacity((int)0) : player.level().getRecipeManager().getRemainingItemsFor(recipeType, recipeInput, player.level());
    }

    @Override
    public void onItemRemoved(Player player, ItemStack stack) {
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList<ItemStack> remainderItems = this.getRemainingItems(this.recipeType, (RecipeInput)this.recipeInput.get(), player);
        CommonHooks.setCraftingPlayer(null);
        for (int i = 0; i < remainderItems.size(); ++i) {
            ItemStack containerStack = this.inventoryContainer.getItem(i);
            ItemStack remainderStack = (ItemStack)remainderItems.get(i);
            if (!containerStack.isEmpty()) {
                this.inventoryContainer.removeItem(i, 1);
                containerStack = this.inventoryContainer.getItem(i);
            }
            if (remainderStack.isEmpty()) continue;
            if (containerStack.isEmpty()) {
                this.inventoryContainer.setItem(i, remainderStack);
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)containerStack, (ItemStack)remainderStack)) {
                remainderStack.grow(containerStack.getCount());
                this.inventoryContainer.setItem(i, remainderStack);
                continue;
            }
            if (this.player.getInventory().add(remainderStack)) continue;
            this.player.drop(remainderStack, false);
        }
    }

    public boolean isFake() {
        return true;
    }
}

