/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu.generic;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class ExtensibleContainerMenu<C extends Container>
extends AbstractContainerMenu {
    public final C inventory;
    protected final ContainerLevelAccess accessValidator;

    public ExtensibleContainerMenu(MenuType<?> type, int containerId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super(type, containerId);
        this.accessValidator = accessValidator;
        this.inventory = this.createInventory();
        int inputSlots = this.inputSlotCount();
        for (int i = 0; i < inputSlots; ++i) {
            this.addSlot(this.createInputSlot(i, this.inventory));
        }
        this.addSlot(this.createOutputSlot(0, playerInventory.player));
    }

    public abstract int inputSlotCount();

    protected abstract C createInventory();

    protected abstract Slot createInputSlot(int var1, C var2);

    protected abstract Slot createOutputSlot(int var1, Player var2);

    protected abstract Block getContainerBlock();

    protected abstract void handleContainerUpdate();

    public int getOutputSlotIndex() {
        return this.inputSlotCount();
    }

    public Slot getOutputSlot() {
        return this.getSlot(this.getOutputSlotIndex());
    }

    public C getInventory() {
        return this.inventory;
    }

    public ItemStack getInputItem(int slotIndex) {
        return this.inventory.getItem(slotIndex);
    }

    public ItemStack getOutputItem() {
        return this.getOutputSlot().getItem();
    }

    public void setInputItem(int slotIndex, ItemStack stack) {
        this.inventory.setItem(slotIndex, stack);
    }

    public void consumeInputItem(int slotIndex, int amount) {
        this.inventory.removeItem(slotIndex, amount);
    }

    public void setOutputItem(ItemStack stack) {
        this.getOutputSlot().set(stack);
    }

    protected void handleContainerClosed(Player player) {
        this.clearContainer(player, (Container)this.inventory);
    }

    public void slotsChanged(Container inventory) {
        this.accessValidator.execute((level, pos) -> {
            this.handleContainerUpdate();
            this.broadcastChanges();
        });
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot != this.getOutputSlot();
    }

    public void removed(Player player) {
        super.removed(player);
        this.accessValidator.execute((world, pos) -> this.handleContainerClosed(player));
    }

    public boolean stillValid(Player player) {
        return ExtensibleContainerMenu.stillValid((ContainerLevelAccess)this.accessValidator, (Player)player, (Block)this.getContainerBlock());
    }

    protected void createPlayerInventory(Inventory playerInventory, int baseX, int baseY) {
        for (int invRow = 0; invRow < 3; ++invRow) {
            for (int invCol = 0; invCol < 9; ++invCol) {
                this.addSlot(new Slot((Container)playerInventory, invCol + invRow * 9 + 9, baseX + invCol * 18, baseY + invRow * 18));
            }
        }
        for (int hotBarSlot = 0; hotBarSlot < 9; ++hotBarSlot) {
            this.addSlot(new Slot((Container)playerInventory, hotBarSlot, baseX + hotBarSlot * 18, baseY + 58));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack newStack = slotStack.copy();
        int outputSlot = this.getOutputSlotIndex();
        int inputSlotsEnd = this.inputSlotCount();
        int nonContainerSlotsStart = outputSlot + 1;
        int lastSlot = this.slots.size();
        if (slotIndex == outputSlot) {
            this.accessValidator.execute((level, pos) -> slotStack.getItem().onCraftedBy(slotStack, player.level(), player));
            if (!this.moveItemStackTo(slotStack, nonContainerSlotsStart, lastSlot, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(slotStack, newStack);
        } else if (slotIndex > outputSlot ? slotIndex < lastSlot && !this.moveItemStackTo(slotStack, 0, inputSlotsEnd, false) : !this.moveItemStackTo(slotStack, nonContainerSlotsStart, lastSlot, false)) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotStack.getCount() == newStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, slotStack);
        if (slotIndex == outputSlot) {
            player.drop(slotStack, false);
        }
        return newStack;
    }

    protected int gridXFromIndex(int index) {
        return index % 3;
    }

    protected int gridYFromIndex(int index) {
        return index / 3;
    }
}

