/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu.container;

import java.util.function.Consumer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;

public class ListenableResultContainer
extends ResultContainer {
    private final Consumer<ItemStack> listener;

    public ListenableResultContainer(Consumer<ItemStack> listener) {
        this.listener = listener;
    }

    public void setItem(int slotIndex, ItemStack stack) {
        super.setItem(slotIndex, stack);
        this.listener.accept(stack);
    }

    public void clearContent() {
        super.clearContent();
        this.listener.accept(ItemStack.EMPTY);
    }

    public ItemStack removeItem(int slotIndex, int count) {
        ItemStack stack = super.removeItem(slotIndex, count);
        this.listener.accept(ItemStack.EMPTY);
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slotIndex) {
        ItemStack stack = super.removeItemNoUpdate(slotIndex);
        this.listener.accept(ItemStack.EMPTY);
        return stack;
    }
}

