/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.common.menu.generic.ExtensibleRecipeMenu;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.menu.provider.GenericMenuProvider;
import net.tslat.aoa3.common.menu.slot.OutputSlot;
import net.tslat.aoa3.common.menu.slot.PredicatedSlot;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class WhitewashingTableMenu
extends ExtensibleRecipeMenu<TransientCraftingContainer, GenericRecipeInput> {
    public WhitewashingTableMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.WHITEWASHING_TABLE.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 60);
    }

    @Override
    protected GenericRecipeInput createRecipeInput() {
        return new GenericRecipeInput(((TransientCraftingContainer)this.getInventory()).getItems());
    }

    @Override
    public int inputSlotCount() {
        return 2;
    }

    @Override
    protected TransientCraftingContainer createInventory() {
        return new TransientCraftingContainer((AbstractContainerMenu)this, 2, 1);
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.WHITEWASHING_TABLE.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, TransientCraftingContainer inventory) {
        int slotX = slotIndex == 0 ? 27 : 76;
        return slotIndex == 0 ? new PredicatedSlot((Container)inventory, slotIndex, slotX, 23, stack -> stack.getItem() == Items.OBSIDIAN) : new PredicatedSlot((Container)inventory, slotIndex, slotX, 23, stack -> stack.getItem() == AoAItems.WHITEWASHING_SOLUTION.get() || stack.getItem() == AoAItems.DARKLY_POWDER.get());
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new OutputSlot((Container)new ResultContainer(), player, slotIndex, 134, 23){

            @Override
            public void onItemRemoved(Player player, ItemStack stack) {
                WhitewashingTableMenu.this.consumeInputItem(0, 1);
                WhitewashingTableMenu.this.consumeInputItem(1, 1);
            }
        };
    }

    @Override
    protected void handleContainerUpdate() {
        ItemStack brickStack = this.getInputItem(0);
        ItemStack powderStack = this.getInputItem(1);
        if (!powderStack.isEmpty() && brickStack.getItem() == Items.OBSIDIAN) {
            if (powderStack.getItem() == AoAItems.DARKLY_POWDER.get()) {
                this.setOutputItem(new ItemStack((ItemLike)AoABlocks.DARKWASH_BRICKS.stone(), 2));
            } else if (powderStack.getItem() == AoAItems.WHITEWASHING_SOLUTION.get()) {
                this.setOutputItem(new ItemStack((ItemLike)AoABlocks.WHITEWASH_BRICKS.stone(), 2));
            } else {
                this.setOutputItem(ItemStack.EMPTY);
            }
        } else {
            this.setOutputItem(ItemStack.EMPTY);
        }
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new GenericMenuProvider("whitewashing_table", pos, WhitewashingTableMenu::new), pos);
    }
}

