/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import net.tslat.aoa3.common.menu.container.UpdatingSimpleContainer;
import net.tslat.aoa3.common.menu.generic.ExtensibleRecipeMenu;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.menu.provider.GenericMenuProvider;
import net.tslat.aoa3.common.menu.slot.OutputSlot;
import net.tslat.aoa3.common.menu.slot.PredicatedSlot;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class MendingTableMenu
extends ExtensibleRecipeMenu<SimpleContainer, GenericRecipeInput> {
    protected int totalRepairCost = 0;

    public MendingTableMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.MENDING_TABLE.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 60);
    }

    @Override
    protected GenericRecipeInput createRecipeInput() {
        return new GenericRecipeInput((List<ItemStack>)((SimpleContainer)this.getInventory()).getItems());
    }

    @Override
    public int inputSlotCount() {
        return 2;
    }

    @Override
    protected SimpleContainer createInventory() {
        return new UpdatingSimpleContainer(2, this::slotsChanged);
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.MENDING_TABLE.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, SimpleContainer inventory) {
        int slotX = slotIndex == 0 ? 27 : 76;
        return slotIndex == 0 ? new PredicatedSlot((Container)inventory, slotIndex, slotX, 23, IItemStackExtension::isRepairable) : new Slot((Container)inventory, slotIndex, slotX, 23);
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new OutputSlot((Container)new ResultContainer(), player, slotIndex, 134, 23){

            @Override
            public void onItemRemoved(Player player, ItemStack stack) {
                MendingTableMenu.this.setInputItem(0, ItemStack.EMPTY);
                MendingTableMenu.this.consumeInputItem(1, MendingTableMenu.this.totalRepairCost);
            }
        };
    }

    @Override
    protected void handleContainerUpdate() {
        ItemStack repairingStack = this.getInputItem(0);
        if (repairingStack.isEmpty() || !repairingStack.isDamaged()) {
            this.setOutputItem(ItemStack.EMPTY);
            return;
        }
        ItemStack repairMaterial = this.getInputItem(1);
        if (repairMaterial.isEmpty()) {
            this.setOutputItem(ItemStack.EMPTY);
            return;
        }
        ItemStack repairedStack = repairingStack.copy();
        if (repairMaterial.getItem() == AoAItems.MAGIC_REPAIR_DUST.get() || repairMaterial.getItem() == AoAItems.MAGIC_MENDING_COMPOUND.get()) {
            int repairPortionValue;
            int n = repairPortionValue = repairMaterial.getItem() == AoAItems.MAGIC_MENDING_COMPOUND.get() ? repairedStack.getDamageValue() : Math.min(repairedStack.getDamageValue(), repairedStack.getMaxDamage() / 5);
            if (repairPortionValue <= 0) {
                this.setOutputItem(ItemStack.EMPTY);
            } else {
                int repairCount;
                for (repairCount = 0; repairPortionValue > 0 && repairCount < repairMaterial.getCount(); ++repairCount) {
                    repairedStack.setDamageValue(repairedStack.getDamageValue() - repairPortionValue);
                    repairPortionValue = Math.min(repairedStack.getDamageValue(), repairedStack.getMaxDamage() / 5);
                }
                this.totalRepairCost = repairCount;
                this.setOutputItem(repairedStack);
            }
        }
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new GenericMenuProvider("mending_table", pos, MendingTableMenu::new), pos);
    }
}

