/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.common.menu.generic.ExtensibleRecipeMenu;
import net.tslat.aoa3.common.menu.provider.GenericMenuProvider;
import net.tslat.aoa3.common.menu.slot.OutputSlot;
import net.tslat.aoa3.common.menu.slot.PredicatedSlot;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class FrameBenchMenu
extends ExtensibleRecipeMenu<TransientCraftingContainer, SingleRecipeInput> {
    private static final Supplier<Item>[] SELECTIONS = new Supplier[]{AoAItems.CROSSBOW_FRAME, AoAItems.BLASTER_FRAME, AoAItems.CANNON_FRAME, AoAItems.HELMET_FRAME, AoAItems.CHESTPLATE_FRAME, AoAItems.LEGGINGS_FRAME, AoAItems.BOOTS_FRAME, AoAItems.GUN_FRAME, AoAItems.SHOTGUN_FRAME, AoAItems.SNIPER_FRAME};
    private int currentSelection = 0;

    public FrameBenchMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.FRAME_BENCH.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 84);
    }

    @Override
    protected SingleRecipeInput createRecipeInput() {
        return new SingleRecipeInput((ItemStack)((TransientCraftingContainer)this.getInventory()).getItems().get(0));
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public int inputSlotCount() {
        return 1;
    }

    @Override
    protected TransientCraftingContainer createInventory() {
        return new TransientCraftingContainer((AbstractContainerMenu)this, 1, 1, NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.FRAME_BENCH.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, TransientCraftingContainer inventory) {
        return new PredicatedSlot((Container)inventory, slotIndex, 11, 34, stack -> stack.getItem() == AoAItems.SCRAP_METAL.get());
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new OutputSlot((Container)new ResultContainer(), player, slotIndex, 149, 34){

            @Override
            public void onItemRemoved(Player player, ItemStack stack) {
                FrameBenchMenu.this.consumeInputItem(0, 1);
            }
        };
    }

    @Override
    protected void handleContainerUpdate() {
        this.setOutputItem(this.getInputItem(0).isEmpty() ? ItemStack.EMPTY : SELECTIONS[this.currentSelection].get().getDefaultInstance());
    }

    public boolean clickMenuButton(Player player, int data) {
        if (this.currentSelection == data) {
            return false;
        }
        this.currentSelection = data;
        this.handleContainerUpdate();
        return true;
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new GenericMenuProvider("frame_bench", pos, FrameBenchMenu::new), pos);
    }
}

