/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.npc.trader.AoABanker;

public class BankerMenu
extends AbstractContainerMenu {
    private final Container inputs;
    private final Container outputs;
    public final AoABanker banker;
    private final Player player;

    public BankerMenu(int screenId, Inventory playerInventory) {
        this(screenId, playerInventory, null);
    }

    public BankerMenu(int screenId, Inventory playerInventory, AoABanker banker) {
        super((MenuType)AoAMenus.BANKER.get(), screenId);
        int i;
        this.player = playerInventory.player;
        this.banker = banker;
        this.inputs = new SimpleContainer(this, 6){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() == BankerMenu.getCoinForSlot(index);
            }
        };
        this.outputs = new SimpleContainer(this, 6){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() == BankerMenu.getCoinForSlot(index + 6);
            }
        };
        for (i = 0; i < 6; ++i) {
            this.addSlot(new Slot(this.inputs, i, i < 3 ? 15 : 101, 28 + i % 3 * 23){

                public boolean mayPlace(ItemStack stack) {
                    return stack.getItem() == BankerMenu.getCoinForSlot(this.getSlotIndex());
                }

                public void setChanged() {
                    super.setChanged();
                    BankerMenu.this.updateOutput(this.getSlotIndex());
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot(new Slot(this.outputs, i, i < 3 ? 58 : 144, 28 + i % 3 * 23){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }

                public boolean mayPickup(Player playerIn) {
                    return this.hasItem();
                }

                public void onTake(Player thePlayer, ItemStack stack) {
                    BankerMenu.this.inputs.getItem(this.getSlotIndex()).shrink(this.getSlotIndex() < 3 ? 20 : 1);
                    BankerMenu.this.updateOutput(this.getSlotIndex());
                }
            });
        }
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.addSlot(new Slot((Container)this.player.getInventory(), inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 105 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.addSlot(new Slot((Container)this.player.getInventory(), hotbarSlot, 8 + hotbarSlot * 18, 163));
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.clearContainer(player, this.inputs);
        }
    }

    protected void updateOutput(int index) {
        ItemStack slotStack = this.inputs.getItem(index);
        if (!(slotStack.isEmpty() || index < 3 && slotStack.getCount() < 20)) {
            this.outputs.setItem(index, new ItemStack((ItemLike)BankerMenu.getCoinForSlot(index + 6), index < 3 ? 1 : 20));
        } else {
            this.outputs.setItem(index, ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index < 12) {
                if (!this.moveItemStackTo(slotStack, 12, 47, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                for (int i = 0; i < 6 && !slotStack.isEmpty(); ++i) {
                    Slot slot2 = (Slot)this.slots.get(i);
                    if (!slot2.hasItem() || slot2.getItem().getItem() != slotStack.getItem()) continue;
                    this.moveItemStackTo(slotStack, i, i + 1, false);
                }
                if (!slotStack.isEmpty() && (index < 39 ? !this.moveItemStackTo(slotStack, 39, 47, true) : !this.moveItemStackTo(slotStack, 12, 38, false))) {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return this.banker != null && this.banker.isAlive() && this.player.distanceToSqr((Entity)this.banker) <= 64.0;
    }

    public static Item getCoinForSlot(int index) {
        return switch (index) {
            case 0, 9 -> (Item)AoAItems.COPPER_COIN.get();
            case 1, 3, 6, 10 -> (Item)AoAItems.SILVER_COIN.get();
            case 2, 4, 7, 11 -> (Item)AoAItems.GOLD_COIN.get();
            case 5, 8 -> (Item)AoAItems.LUNAVER_COIN.get();
            default -> Items.AIR;
        };
    }
}

