/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.util.StringUtil;

public class WorldEventCommand
implements Command<CommandSourceStack> {
    private static final WorldEventCommand CMD = new WorldEventCommand();
    private static final SuggestionProvider<CommandSourceStack> EVENT_SUGGESTIONS = (context, builder) -> {
        ReloadableServerRegistries.Holder reloadableRegistries = ((CommandSourceStack)context.getSource()).getServer().reloadableRegistries();
        return SharedSuggestionProvider.suggestResource(reloadableRegistries.getKeys(AoARegistries.WORLD_EVENTS_REGISTRY_KEY).stream().filter(id -> AoAWorldEventManager.getEventById((Level)((CommandSourceStack)context.getSource()).getLevel(), id) != null).toList(), (SuggestionsBuilder)builder);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldevent").requires(command -> command.hasPermission(4))).executes((Command)CMD);
        builder.then(Commands.argument((String)"level", (ArgumentType)DimensionArgument.dimension()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"event", (ArgumentType)ResourceLocationArgument.id()).suggests(EVENT_SUGGESTIONS).then(Commands.literal((String)"check").executes(cmd -> WorldEventCommand.checkEvent((CommandContext<CommandSourceStack>)cmd, DimensionArgument.getDimension((CommandContext)cmd, (String)"level"))))).then(Commands.literal((String)"start").executes(cmd -> WorldEventCommand.startEvent((CommandContext<CommandSourceStack>)cmd, DimensionArgument.getDimension((CommandContext)cmd, (String)"level"))))).then(Commands.literal((String)"stop").executes(cmd -> WorldEventCommand.stopEvent((CommandContext<CommandSourceStack>)cmd, DimensionArgument.getDimension((CommandContext)cmd, (String)"level"))))));
        return builder;
    }

    private static int checkEvent(CommandContext<CommandSourceStack> context, ServerLevel level) throws CommandSyntaxException {
        ResourceLocation eventId = ResourceLocationArgument.getId(context, (String)"event");
        AoAWorldEvent event = AoAWorldEventManager.getEventById((Level)level, eventId);
        if (event == null) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.noEvent", AoACommand.CommandFeedbackType.WARN, new Component[]{Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath())), Component.literal((String)eventId.toString())});
            return 0;
        }
        if (event.isActive()) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.active", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
            return 1;
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.inactive", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
        return 0;
    }

    private static int startEvent(CommandContext<CommandSourceStack> context, ServerLevel level) throws CommandSyntaxException {
        ResourceLocation eventId = ResourceLocationArgument.getId(context, (String)"event");
        AoAWorldEvent event = AoAWorldEventManager.getEventById((Level)level, eventId);
        if (event == null) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.noEvent", AoACommand.CommandFeedbackType.WARN, new Component[]{Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath())), Component.literal((String)eventId.toString())});
            return 0;
        }
        if (event.isActive()) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.alreadyActive", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
            return 0;
        }
        event.start(level);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.start", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
        return 1;
    }

    private static int stopEvent(CommandContext<CommandSourceStack> context, ServerLevel level) throws CommandSyntaxException {
        ResourceLocation eventId = ResourceLocationArgument.getId(context, (String)"event");
        AoAWorldEvent event = AoAWorldEventManager.getEventById((Level)level, eventId);
        if (event == null) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.noEvent", AoACommand.CommandFeedbackType.WARN, new Component[]{Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath())), Component.literal((String)eventId.toString())});
            return 0;
        }
        if (!event.isActive()) {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.alreadyInactive", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
            return 0;
        }
        event.stop(level);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.stop", AoACommand.CommandFeedbackType.INFO, new Component[]{Component.literal((String)eventId.toString()), Component.literal((String)StringUtil.toTitleCase(level.dimension().location().getPath()))});
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "WorldEvent", "command.aoa.worldevent.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }
}

