/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.command.EnumArgument;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.StringUtil;

public class ScreenEffectCommand
implements Command<CommandSourceStack> {
    private static final ScreenEffectCommand CMD = new ScreenEffectCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"screeneffect").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(command -> command.hasPermission(1))).then(Commands.argument((String)"effect", (ArgumentType)EnumArgument.enumArgument(ScreenImageEffect.Type.class)).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(cmd -> ScreenEffectCommand.doScreenEffect((CommandContext<CommandSourceStack>)cmd, new ColourUtil.Colour(1.0f, 1.0f, 1.0f, 1.0f), 1.0f, false))).then(Commands.argument((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(Commands.argument((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(Commands.argument((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(((RequiredArgumentBuilder)Commands.argument((String)"alpha", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(cmd -> ScreenEffectCommand.doScreenEffect((CommandContext<CommandSourceStack>)cmd, ScreenEffectCommand.colourFromArgs((CommandContext<CommandSourceStack>)cmd), 1.0f, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(cmd -> ScreenEffectCommand.doScreenEffect((CommandContext<CommandSourceStack>)cmd, ScreenEffectCommand.colourFromArgs((CommandContext<CommandSourceStack>)cmd), FloatArgumentType.getFloat((CommandContext)cmd, (String)"scale"), false))).then(Commands.argument((String)"fullscreen", (ArgumentType)BoolArgumentType.bool()).executes(cmd -> ScreenEffectCommand.doScreenEffect((CommandContext<CommandSourceStack>)cmd, ScreenEffectCommand.colourFromArgs((CommandContext<CommandSourceStack>)cmd), FloatArgumentType.getFloat((CommandContext)cmd, (String)"scale"), BoolArgumentType.getBool((CommandContext)cmd, (String)"fullscreen"))))))))))));
        return builder;
    }

    private static ColourUtil.Colour colourFromArgs(CommandContext<CommandSourceStack> cmd) {
        return new ColourUtil.Colour((float)IntegerArgumentType.getInteger(cmd, (String)"red") / 255.0f, (float)IntegerArgumentType.getInteger(cmd, (String)"green") / 255.0f, (float)IntegerArgumentType.getInteger(cmd, (String)"blue") / 255.0f, (float)IntegerArgumentType.getInteger(cmd, (String)"alpha") / 255.0f);
    }

    private static int doScreenEffect(CommandContext<CommandSourceStack> cmd, ColourUtil.Colour colour, float scale, boolean fullscreen) throws CommandSyntaxException {
        ScreenImageEffect effect = new ScreenImageEffect((ScreenImageEffect.Type)((Object)cmd.getArgument("effect", ScreenImageEffect.Type.class))).duration(IntegerArgumentType.getInteger(cmd, (String)"duration")).fullscreen(fullscreen).scaled(scale).coloured(colour.argbInt());
        Collection players = EntityArgument.getPlayers(cmd, (String)"players");
        for (ServerPlayer pl : players) {
            effect.sendToPlayer(pl);
        }
        if (players.size() == 1) {
            AoACommand.feedback((CommandSourceStack)cmd.getSource(), "ScreenEffect", "command.aoa.screeneffect.success.single", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{Component.literal((String)StringUtil.toTitleCase(effect.getType().name())), ((ServerPlayer)players.iterator().next()).getDisplayName(), Component.literal((String)NumberUtil.roundToNthDecimalPlace((float)effect.getDuration() / 20.0f, 1))});
        } else {
            AoACommand.feedback((CommandSourceStack)cmd.getSource(), "ScreenEffect", "command.aoa.screeneffect.success.multiple", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{Component.literal((String)StringUtil.toTitleCase(effect.getType().name())), Component.literal((String)String.valueOf(players.size())), Component.literal((String)NumberUtil.roundToNthDecimalPlace((float)effect.getDuration() / 20.0f, 1))});
        }
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "ScreenEffect", "command.aoa.screeneffect.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }
}

