/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.util.PlayerUtil;

public class PortalResetCommand
implements Command<CommandSourceStack> {
    private static final PortalResetCommand CMD = new PortalResetCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"portalreset").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(command -> command.hasPermission(0))).executes(context -> PortalResetCommand.resetPortals((CommandContext<CommandSourceStack>)context, (Entity)EntityArgument.getPlayer((CommandContext)context, (String)"player"))));
        return builder;
    }

    private static int resetPortals(CommandContext<CommandSourceStack> cmd, Entity entity) throws CommandSyntaxException {
        ServerPlayer pl = (ServerPlayer)entity;
        if (pl != ((CommandSourceStack)cmd.getSource()).getEntity() && !((CommandSourceStack)cmd.getSource()).hasPermission(4)) {
            throw AoACommand.NO_PERMISSION_EXCEPTION.create();
        }
        AoACommand.feedback((CommandSourceStack)cmd.getSource(), "PortalReset", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.getPortalReturnLocations().clear();
        AoACommand.feedback((CommandSourceStack)cmd.getSource(), "PortalReset", "command.aoa.portalreset.success", AoACommand.CommandFeedbackType.SUCCESS, new Component[0]);
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "PortalReset", "command.aoa.portalreset.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }
}

