/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.projectile.bullets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.tslat.aoa3.client.render.entity.projectile.TexturedProjectileRenderer;
import net.tslat.aoa3.content.entity.projectile.gun.ShoeShotEntity;
import org.joml.Matrix4f;

public class ShoeShotRenderer
extends TexturedProjectileRenderer<ShoeShotEntity> {
    public ShoeShotRenderer(EntityRendererProvider.Context manager, ResourceLocation texture) {
        super(manager, texture);
    }

    @Override
    public void render(ShoeShotEntity entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(((float)entity.tickCount + partialTick) / 0.3f * 57.295776f));
        PoseStack.Pose poseState = poseStack.last();
        Matrix4f pose = poseState.pose();
        VertexConsumer vertexConsumer = buffer.getBuffer(this.renderType);
        ShoeShotRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 0.0f, 0.0f, 0.0f, 1.0f);
        ShoeShotRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 1.0f, 0.0f, 1.0f, 1.0f);
        ShoeShotRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 1.0f, 1.0f, 1.0f, 0.0f);
        ShoeShotRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
        RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent((Entity)entity, entity.getDisplayName(), (EntityRenderer)this, poseStack, buffer, packedLight, partialTick);
        NeoForge.EVENT_BUS.post((Event)renderNameTagEvent);
        if (renderNameTagEvent.canRender() != TriState.FALSE && (renderNameTagEvent.canRender() == TriState.TRUE || this.shouldShowName((Entity)entity))) {
            this.renderNameTag((Entity)entity, renderNameTagEvent.getContent(), poseStack, buffer, packedLight, partialTick);
        }
    }
}

