/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class TexturedProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected final ResourceLocation texture;
    protected RenderType renderType;
    protected float scale = 0.5f;

    public TexturedProjectileRenderer(EntityRendererProvider.Context renderManager, ResourceLocation texture) {
        super(renderManager);
        this.texture = texture;
        this.renderType = RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public TexturedProjectileRenderer<T> withScale(float scale) {
        this.scale = scale;
        return this;
    }

    public TexturedProjectileRenderer<T> withRenderType(Function<ResourceLocation, RenderType> renderTypeFunction) {
        this.renderType = renderTypeFunction.apply(this.texture);
        return this;
    }

    public void render(T entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(this.scale, this.scale, this.scale);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose poseState = poseStack.last();
        Matrix4f pose = poseState.pose();
        VertexConsumer vertexConsumer = buffer.getBuffer(this.renderType);
        TexturedProjectileRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 0.0f, 0.0f, 0.0f, 1.0f);
        TexturedProjectileRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 1.0f, 0.0f, 1.0f, 1.0f);
        TexturedProjectileRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 1.0f, 1.0f, 1.0f, 0.0f);
        TexturedProjectileRenderer.vertex(vertexConsumer, pose, poseState, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
        super.render(entity, yaw, partialTick, poseStack, buffer, packedLight);
    }

    protected static void vertex(VertexConsumer vertexConsumer, Matrix4f pose, PoseStack.Pose poseState, int packedLight, float x, float y, float u, float v) {
        vertexConsumer.addVertex(pose, x - 0.5f, y - 0.25f, 0.0f).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseState, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(T projectile) {
        return this.texture;
    }
}

