/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.util.ColourUtil;
import org.jetbrains.annotations.Nullable;

public class ModelledProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final ResourceLocation texture;
    protected final EntityModel<? super T> model;

    public ModelledProjectileRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation, Function<ModelPart, EntityModel<? super T>> model, ResourceLocation texture) {
        super(context);
        this.model = model.apply(context.bakeLayer(modelLayerLocation));
        this.texture = texture;
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.pushPose();
        matrix.scale(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(entity, matrix, partialTicks);
        float pitch = Mth.lerp((float)partialTicks, (float)((Entity)entity).xRotO, (float)entity.getXRot());
        this.model.prepareMobModel(entity, 0.0f, 0.0f, partialTicks);
        this.model.setupAnim(entity, 0.0f, partialTicks, (float)((Entity)entity).tickCount, 0.0f, pitch);
        matrix.translate(0.0, (double)-1.6f, 0.0);
        boolean visible = !entity.isInvisible();
        boolean shade = !visible && !entity.isInvisibleTo((Player)Minecraft.getInstance().player);
        RenderType rendertype = this.getRenderType(entity, visible, shade);
        if (rendertype != null) {
            VertexConsumer vertexConsumer = buffer.getBuffer(rendertype);
            this.model.renderToBuffer(matrix, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, ColourUtil.ARGB(1.0f, 1.0f, 1.0f, shade ? 0.15f : 1.0f));
        }
        matrix.popPose();
        super.render(entity, yaw, partialTicks, matrix, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean visible, boolean shade) {
        ResourceLocation texture = this.getTextureLocation(entity);
        if (shade) {
            return RenderType.entityTranslucent((ResourceLocation)texture);
        }
        if (visible) {
            return this.model.renderType(texture);
        }
        return entity.isCurrentlyGlowing() ? RenderType.outline((ResourceLocation)texture) : null;
    }

    protected void preRenderCallback(T entity, PoseStack matrix, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }
}

