/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.content.item.tool.pickaxe.OccultPickaxe;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.util.ColourUtil;

public final class OccultBlockRenderer {
    private static final RenderType CUSTOM_LINES_RENDER_TYPE = RenderType.create((String)"occult_block_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(5.0))).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.OUTLINE_TARGET).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    private static final CopyOnWriteArrayList<IntObjectPair<List<OccultPickaxe.LocatedBlock>>> OCCULT_BLOCKS = new CopyOnWriteArrayList();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderLevelStageEvent.class, OccultBlockRenderer::onWorldRender);
    }

    public static void addOccultBlocks(int renderUntil, List<OccultPickaxe.LocatedBlock> blocks) {
        OCCULT_BLOCKS.add((IntObjectPair<List<OccultPickaxe.LocatedBlock>>)IntObjectPair.of((int)renderUntil, blocks));
    }

    private static void onWorldRender(RenderLevelStageEvent ev) {
        if (ev.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES || OCCULT_BLOCKS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        boolean rendered = false;
        PoseStack poseStack = ev.getPoseStack();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer(CUSTOM_LINES_RENDER_TYPE);
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        PoseStack.Pose pose = poseStack.last();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        OCCULT_BLOCKS.removeIf(entry -> GlobalEvents.tick >= entry.leftInt());
        for (IntObjectPair<List<OccultPickaxe.LocatedBlock>> entry2 : OCCULT_BLOCKS) {
            Iterator iterator = ((List)entry2.right()).iterator();
            while (iterator.hasNext()) {
                OccultPickaxe.LocatedBlock block = (OccultPickaxe.LocatedBlock)iterator.next();
                if (GlobalEvents.tick % 2 == 1 && mc.player.level().getBlockState(block.pos()) != block.state()) {
                    iterator.remove();
                    continue;
                }
                BlockPos pos = block.pos();
                VoxelShape shape = block.state().getShape((BlockGetter)mc.level, pos, CollisionContext.of((Entity)mc.player));
                ColourUtil.Colour colour = block.colour();
                rendered = true;
                shape.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    float lengthX = (float)(maxX - minX);
                    float lengthY = (float)(maxY - minY);
                    float lengthZ = (float)(maxZ - minZ);
                    float length = Mth.sqrt((float)(lengthX * lengthX + lengthY * lengthY + lengthZ * lengthZ));
                    buffer.addVertex(pose.pose(), (float)minX + (float)pos.getX(), (float)minY + (float)pos.getY(), (float)minZ + (float)pos.getZ()).setColor(colour.red(), colour.green(), colour.blue(), colour.alpha()).setNormal(pose, lengthX /= length, lengthY /= length, lengthZ /= length);
                    buffer.addVertex(pose.pose(), (float)maxX + (float)pos.getX(), (float)maxY + (float)pos.getY(), (float)maxZ + (float)pos.getZ()).setColor(colour.red(), colour.green(), colour.blue(), colour.alpha()).setNormal(pose, lengthX, lengthY, lengthZ);
                });
            }
        }
        poseStack.popPose();
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        if (rendered) {
            mc.renderBuffers().bufferSource().endBatch();
        }
    }
}

