/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAEntityRendering;
import net.tslat.aoa3.client.model.misc.LottoTotemModel;
import net.tslat.aoa3.content.entity.misc.LottoTotemEntity;
import org.jetbrains.annotations.Nullable;

public class LottoTotemRenderer
extends EntityRenderer<LottoTotemEntity> {
    private final ResourceLocation texture = AdventOfAscension.id("textures/entity/misc/lotto_totem.png");
    private final LottoTotemModel model;

    public LottoTotemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.model = new LottoTotemModel(renderManager.bakeLayer(AoAEntityRendering.LOTTO_TOTEM.getMainLayerLocation()));
    }

    public void render(LottoTotemEntity entity, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.pushPose();
        matrix.translate(0.0, 1.5, 0.0);
        matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrix.scale(-1.0f, 1.0f, -1.0f);
        VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.texture));
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)entity.tickCount, entityYaw, 0.0f);
        this.model.renderToBuffer(matrix, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        matrix.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrix, buffer, packedLight);
    }

    @Nullable
    public ResourceLocation getTextureLocation(LottoTotemEntity entity) {
        return this.texture;
    }
}

