/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.content.entity.misc.FakeTntEntity;

public class FakeTntRenderer
extends EntityRenderer<FakeTntEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public FakeTntRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(FakeTntEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5f, 0.0f);
        float fuseTick = entity.getFuse();
        if (fuseTick - partialTicks + 1.0f < 10.0f) {
            float swell = Mth.clamp((float)(1.0f - (fuseTick - partialTicks + 1.0f) / 10.0f), (float)0.0f, (float)1.0f);
            float scale = 1.0f + swell * swell * swell * 0.3f;
            poseStack.scale(scale, scale, scale);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5f, -0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)Blocks.TNT.defaultBlockState(), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, ((int)fuseTick / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(FakeTntEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

