/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.layer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.model.misc.PlayerHaloModel;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.player.halo.HaloTypes;
import net.tslat.aoa3.player.halo.PlayerHaloManager;
import net.tslat.aoa3.util.ColourUtil;

public class PlayerHaloRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation TEXTURE = AdventOfAscension.id("textures/entity/player/halo_texture.png");
    private static final RenderType TSLAT_HALO_RENDER_TYPE = PlayerHaloRenderLayer.getTslatHaloRenderType();
    private final PlayerHaloModel model;

    public PlayerHaloRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.model = new PlayerHaloModel(modelSet.bakeLayer(PlayerHaloModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float netHeadPitch) {
        if (!player.isInvisible() && ((Boolean)AoAConfigs.CLIENT.showPlayerHalos.get()).booleanValue()) {
            PlayerHaloManager.getHaloForRender(player.getUUID()).ifPresent(halo -> {
                if (halo == HaloTypes.TSLAT) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(TSLAT_HALO_RENDER_TYPE);
                    this.model.root.copyFrom(((PlayerModel)this.getParentModel()).getHead());
                    this.model.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, ColourUtil.ARGB(0.0f, 0.0f, 0.0f, 0.1f));
                    return;
                }
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                switch (halo) {
                    case DONATOR: {
                        red = 1.0f;
                        green = 1.0f;
                        break;
                    }
                    case SUPER_DONATOR: {
                        red = 1.0f;
                        break;
                    }
                    case STAFF: {
                        red = 0.6f;
                        green = 1.0f;
                        blue = 1.0f;
                        break;
                    }
                    case WIKI_EDITOR: {
                        blue = 1.0f;
                    }
                }
                RenderSystem.enableBlend();
                RenderSystem.disableDepthTest();
                this.model.root.copyFrom(((PlayerModel)this.getParentModel()).getHead());
                this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(player))), 0xF000F0, OverlayTexture.NO_OVERLAY, ColourUtil.ARGB(red, green, blue, 0.1f));
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
            });
        }
    }

    protected ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return TEXTURE;
    }

    private static RenderType getTslatHaloRenderType() {
        RenderStateShard.TransparencyStateShard transparencyState = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        return RenderType.create((String)"halo", (VertexFormat)DefaultVertexFormat.POSITION, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEndGatewayShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_PORTAL_LOCATION, true, false).add(TheEndPortalRenderer.END_SKY_LOCATION, true, false).add(TheEndPortalRenderer.END_SKY_LOCATION, true, false).build()).setTransparencyState(transparencyState).createCompositeState(false));
    }
}

