/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.animal.precasia;

import it.unimi.dsi.fastutil.floats.FloatFloatPair;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.model.entity.mob.MultiStageHeadModel;
import net.tslat.aoa3.content.entity.animal.precasia.OpteryxEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;

public class OpteryxModel
extends MultiStageHeadModel<OpteryxEntity> {
    public OpteryxModel() {
        super(AdventOfAscension.id("animal/precasia/opteryx"));
        this.withStages(new MultiStageHeadModel.Stage("head", FloatFloatPair.of((float)-45.0f, (float)-14.0f), FloatFloatPair.of((float)-21.0f, (float)21.0f)), new MultiStageHeadModel.Stage("neck", FloatFloatPair.of((float)5.0f, (float)30.0f), FloatFloatPair.of((float)-32.0f, (float)32.0f)));
    }

    public ResourceLocation getModelResource(OpteryxEntity animatable) {
        if (animatable.isEgg()) {
            return this.buildFormattedModelPath(AdventOfAscension.id("animal/precasia/opteryx_egg"));
        }
        return super.getModelResource((GeoAnimatable)animatable);
    }

    public ResourceLocation getTextureResource(OpteryxEntity animatable) {
        if (animatable.isEgg()) {
            return this.buildFormattedTexturePath(AdventOfAscension.id("animal/precasia/opteryx_egg"));
        }
        return super.getTextureResource((GeoAnimatable)animatable);
    }

    @Override
    public void setCustomAnimations(OpteryxEntity animatable, long instanceId, AnimationState<OpteryxEntity> animationState) {
        if (animatable.isEgg()) {
            return;
        }
        super.setCustomAnimations(animatable, instanceId, animationState);
        boolean isBaby = animatable.isBaby();
        float headMod = isBaby ? 1.5f : 1.0f;
        float rootMod = isBaby ? 0.5f : 1.0f;
        this.getBone("body").ifPresent(bone -> bone.updateScale(rootMod, rootMod, rootMod));
        this.getBone("head").ifPresent(bone -> bone.updateScale(headMod, headMod, headMod));
        this.getBone("bone5").ifPresent(bone -> bone.setHidden(isBaby));
    }
}

