/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.dimension;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.dimension.AoADimensionEffectsRenderer;
import net.tslat.aoa3.util.RenderUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class LunalusRenderingEffects
extends AoADimensionEffectsRenderer {
    public static final ResourceLocation ID = AdventOfAscension.id("lunalus");
    private static final ResourceLocation TEXTURE = AdventOfAscension.id("textures/gui/realmstonegui/background.png");

    LunalusRenderingEffects() {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true);
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        PoseStack poseStack = new PoseStack();
        Tesselator tesellator = Tesselator.getInstance();
        poseStack.mulPose(frustumMatrix);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderUtil.prepRenderTexture(TEXTURE);
        for (int i = 0; i < 6; ++i) {
            poseStack.pushPose();
            switch (i) {
                case 1: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case 2: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case 4: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case 5: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    break;
                }
            }
            Matrix4f pose = poseStack.last().pose();
            BufferBuilder buffer = tesellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buffer.addVertex(pose, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(150, 150, 150, 255);
            buffer.addVertex(pose, -100.0f, -100.0f, 100.0f).setUv(0.0f, 1.0f).setColor(150, 150, 150, 255);
            buffer.addVertex(pose, 100.0f, -100.0f, 100.0f).setUv(1.0f, 1.0f).setColor(150, 150, 150, 255);
            buffer.addVertex(pose, 100.0f, -100.0f, -100.0f).setUv(1.0f, 0.0f).setColor(150, 150, 150, 255);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        return true;
    }

    @Override
    public Vec3 getBrightnessDependentFogColor(Vec3 biomeFogColour, float celestialAngle) {
        return biomeFogColour;
    }

    @Override
    @Nullable
    public float[] getSunriseColor(float celestialAngle, float partialTicks) {
        return null;
    }
}

