/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.dimension;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.render.dimension.AoADimensionEffectsRenderer;
import org.jetbrains.annotations.Nullable;

public class AbyssRenderingEffects
extends AoADimensionEffectsRenderer {
    public static final ResourceLocation ID = AdventOfAscension.id("abyss");

    AbyssRenderingEffects() {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.noWeather();
    }

    @Override
    public void adjustFogRender(ClientLevel level, FogRenderer.FogMode fogMode, FogType fogType, Camera camera, FloatConsumer farPlaneDistance, FloatConsumer nearPlaneDistance) {
        float mod = Math.max(0.0f, (float)camera.getPosition().y - 180.0f);
        farPlaneDistance.accept(20.0f + mod);
        nearPlaneDistance.accept(-50.0f + mod);
    }

    @Override
    public boolean isFoggyAt(int xCoord, int yCoord) {
        return true;
    }

    @Override
    @Nullable
    public float[] getSunriseColor(float dayProgress, float partialTick) {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    @Override
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColour, float brightness) {
        return fogColour.scale((double)(brightness * (float)((Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().y - 50.0) / (double)ClientOperations.getLevel().getMaxBuildHeight())));
    }
}

