/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.content.block.blockentity.TrophyBlockEntity;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    public TrophyRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TrophyBlockEntity blockEntity, float partialTick, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Entity entity = blockEntity.getCachedEntity();
        if (entity != null) {
            matrix.pushPose();
            matrix.translate(0.5f, 0.0f, 0.5f);
            float scale = 0.53125f;
            float maxScale = Math.max(entity.getBbWidth(), entity.getBbHeight());
            double hover = (double)Mth.sin((float)((float)blockEntity.hoverStep + partialTick)) / 30.0;
            blockEntity.hoverStep += hover * (double)0.01f;
            RandomSource random = entity.level().getRandom();
            if ((double)maxScale > 1.0) {
                scale /= maxScale;
            }
            matrix.translate(0.0, -0.1, 0.0);
            matrix.scale(scale, scale, scale);
            matrix.translate(0.0f, 1.0f / scale, 0.0f);
            if (blockEntity.getTrophyData().isOriginalTrophy() && !Minecraft.getInstance().isPaused() && random.nextInt(5) == 0) {
                float colourMod = random.nextFloat() * 0.7f + 0.3f;
                Vec3 pos = Vec3.atBottomCenterOf((Vec3i)blockEntity.getBlockPos()).add(random.nextGaussian() * (double)(entity.getBbWidth() / 2.0f) * (double)scale * 0.75, (double)(0.9f + random.nextFloat() * entity.getBbHeight() * scale), random.nextGaussian() * (double)(entity.getBbWidth() / 2.0f) * (double)scale * 0.75);
                ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.GLOW, (Vec3[])new Vec3[]{pos}).scaleMod(0.05f).lifespan(Mth.ceil((float)(10.0f * (random.nextFloat() * 0.8f + 0.2f)))).colourOverride(colourMod, colourMod * 200.0f / 255.0f, 0.0f, 1.0f).power(Vec3.ZERO).spawnParticles(entity.level());
            }
            if (((Boolean)AoAConfigs.CLIENT.rotatingTrophies.get()).booleanValue()) {
                matrix.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)blockEntity.getPrevMobRotation(), (float)blockEntity.getMobRotation()) * 30.0f));
            }
            Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, combinedLight);
            matrix.popPose();
        }
    }
}

