/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.block.blockentity.InfusionTableBlockEntity;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class InfusionTableRenderer
implements BlockEntityRenderer<InfusionTableBlockEntity> {
    public InfusionTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(InfusionTableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        NonNullList<ItemStack> contents = blockEntity.getItems();
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        BlockPos abovePos = pos.above();
        if (level != null) {
            if (level.getBlockState(abovePos).isSolidRender((BlockGetter)level, abovePos)) {
                return;
            }
            combinedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)abovePos);
        } else {
            combinedLight = 0xF000F0;
        }
        poseStack.pushPose();
        poseStack.scale(0.25f, 0.25f, 0.25f);
        poseStack.translate(1.25f, 4.25f, 1.25f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        ItemStack input = (ItemStack)contents.get(0);
        ItemStack output = (ItemStack)contents.get(10);
        if (!input.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.75f, 1.25f, -0.75f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)level.getGameTime() + partialTick));
            poseStack.scale(1.25f, 1.25f, 1.25f);
            if (!(input.getItem() instanceof BlockItem)) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
            }
            renderer.renderStatic(input, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (!output.isEmpty() && RandomUtil.oneInNChance((int)10)) {
                Vec3 slotItemPos = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).add(level.random.nextGaussian() * (double)0.02f, 0.9, level.random.nextGaussian() * (double)0.02f);
                Vec3 velocity = slotItemPos.vectorTo(slotItemPos.add(0.0, 0.25, 0.0)).scale(0.02);
                ParticleBuilder.forPositions((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, input), (Vec3[])new Vec3[]{slotItemPos}).scaleMod(0.125f).gravityOverride(0.0f).velocity(0.0, 0.0, 0.0).lifespan(30).particleConsumer(particle -> ((Particle)particle).setParticleSpeed(velocity.x, velocity.y, velocity.z)).cutoffDistance(20.0).spawnParticles(level);
            }
        }
        if (!output.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.75f, 2.0f, -0.75f);
            poseStack.mulPose(Axis.YN.rotationDegrees((float)level.getGameTime() + partialTick));
            poseStack.scale(1.75f, 1.75f, 1.75f);
            if (!(output.getItem() instanceof BlockItem)) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
            }
            renderer.renderStatic(output, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
        for (int i = 1; i < 10; ++i) {
            Vec3 velocity;
            ItemStack stack = (ItemStack)contents.get(i);
            if (stack.isEmpty()) continue;
            int row = (i - 1) % 3;
            int column = (i - 1) / 3;
            poseStack.pushPose();
            poseStack.translate(-0.75f * (float)row, 0.0f, -0.75f * (float)column);
            if (!(stack.getItem() instanceof BlockItem)) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
            }
            renderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, blockEntity.getLevel(), 0);
            poseStack.popPose();
            if (!RandomUtil.oneInNChance((int)(input.isEmpty() ? 50 : 10))) continue;
            Vec3 slotItemPos = Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos()).add(0.3125, 1.0, 0.3125).add((double)((float)row * 0.1875f), 0.0625, (double)((float)column * 0.1875f)).add(level.random.nextGaussian() * (double)0.02f, level.random.nextGaussian() * (double)0.02f, level.random.nextGaussian() * (double)0.02f);
            if (input.isEmpty()) {
                velocity = new Vec3(level.random.nextGaussian() * (double)0.001f, (double)0.01f, level.random.nextGaussian() * (double)0.001f);
            } else {
                Vec3 targetPos = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).add(0.0, 0.95, 0.0);
                velocity = slotItemPos.vectorTo(targetPos).normalize().scale((double)0.0125f);
            }
            ParticleBuilder.forPositions((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (Vec3[])new Vec3[]{slotItemPos}).scaleMod(0.125f).gravityOverride(0.0f).velocity(0.0, 0.0, 0.0).lifespan(30).particleConsumer(particle -> ((Particle)particle).setParticleSpeed(velocity.x, velocity.y, velocity.z)).cutoffDistance(20.0).spawnParticles(level);
        }
        poseStack.popPose();
    }
}

