/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle.entityaffecting;

import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.particle.entityaffecting.EntityAffectingParticle;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.ParticleEffectPacket;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class FreezingSnowflakeParticle
extends EntityAffectingParticle {
    private final int particleSourceId;

    public FreezingSnowflakeParticle(ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity, @Nullable SpriteSet sprites, int entitySourceId) {
        super(level, x, y, z, xVelocity, yVelocity, zVelocity);
        this.xd = xVelocity;
        this.yd = yVelocity;
        this.zd = zVelocity;
        this.quadSize = (this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f) * 0.35f / 5.0f;
        this.lifetime = Mth.ceil((float)(5.0f / (this.random.nextFloat() * 0.8f + 0.2f)));
        this.particleSourceId = entitySourceId;
        this.setSize(0.2f, 0.2f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    protected boolean handleEntityCollision(Entity collidedEntity) {
        if ((float)collidedEntity.getTicksFrozen() <= (float)collidedEntity.getTicksRequiredToFreeze() * 2.5f && collidedEntity instanceof Player) {
            AoANetworking.sendToServer(new ParticleEffectPacket(ParticleEffectPacket.Type.FREEZING_SNOWFLAKE, this.particleSourceId, collidedEntity.getId()));
        }
        return true;
    }

    @Override
    @Nullable
    protected Entity getCollidedEntity(double xVelocity, double yVelocity, double zVelocity) {
        if (this.particleSourceId == -1) {
            return null;
        }
        return EntityRetrievalUtil.getNearestEntity((Level)this.level, (AABB)this.getBoundingBox().expandTowards(xVelocity, yVelocity, zVelocity), (Vec3)new Vec3(this.x, this.y, this.z), (Predicate)EntityPredicate.TARGETABLE_ENTITIES.and(entity -> entity.getId() != this.particleSourceId));
    }
}

