/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle.entityaffecting;

import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.particle.entityaffecting.EntityAffectingParticle;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.ParticleEffectPacket;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class BurningFlameParticle
extends EntityAffectingParticle {
    private final SpriteSet sprites;
    private final int particleSourceId;

    public BurningFlameParticle(ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity, SpriteSet sprites, int entitySourceId) {
        super(level, x, y, z, xVelocity, yVelocity, zVelocity);
        this.sprites = sprites;
        this.xd = xVelocity;
        this.yd = yVelocity;
        this.zd = zVelocity;
        this.quadSize = (this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f) * 0.35f / 5.0f;
        this.lifetime = Mth.ceil((float)(5.0f / (this.random.nextFloat() * 0.8f + 0.2f)));
        this.particleSourceId = entitySourceId;
        this.setSpriteFromAge(this.sprites);
        this.setSize(0.2f, 0.2f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public int getLightColor(float partialTick) {
        float lerpAge = Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f) * 240.0f;
        int baseColour = super.getLightColor(partialTick);
        int colourMod = (baseColour & 0xFF) + (int)lerpAge;
        if (colourMod > 240) {
            colourMod = 240;
        }
        return colourMod | (baseColour >> 16 & 0xFF) << 16;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    @Override
    protected boolean handleEntityCollision(Entity collidedEntity) {
        if (EntityPredicate.DAMAGEABLE_ENTITIES.test(collidedEntity)) {
            AoANetworking.sendToServer(new ParticleEffectPacket(ParticleEffectPacket.Type.BURNING_FLAME, this.particleSourceId, collidedEntity.getId()));
        }
        return super.handleEntityCollision(collidedEntity);
    }

    @Override
    @Nullable
    protected Entity getCollidedEntity(double xVelocity, double yVelocity, double zVelocity) {
        if (this.particleSourceId == -1) {
            return null;
        }
        return EntityRetrievalUtil.getNearestEntity((Level)this.level, (AABB)this.getBoundingBox().expandTowards(xVelocity, yVelocity, zVelocity), (Vec3)new Vec3(this.x, this.y, this.z), (Predicate)EntityPredicate.TARGETABLE_ENTITIES.and(entity -> entity.getId() != this.particleSourceId));
    }

    public static class Provider
    implements ParticleProvider<EntityTrackingParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(EntityTrackingParticleOptions data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return new BurningFlameParticle(level, x, y, z, xVelocity, yVelocity, zVelocity, this.sprites, data.entitySourceId());
        }
    }
}

