/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import org.jetbrains.annotations.Nullable;

public class GenericSpriteParticle
extends TextureSheetParticle {
    @Nullable
    private final SpriteSet sprites;

    public GenericSpriteParticle(ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity, @Nullable SpriteSet sprites) {
        super(level, x, y, z, xVelocity, yVelocity, zVelocity);
        this.sprites = sprites;
        this.xd = xVelocity + (double)((float)(this.random.nextDouble() * 2.0 - 1.0) * 0.05f);
        this.yd = yVelocity + (double)((float)(this.random.nextDouble() * 2.0 - 1.0) * 0.05f);
        this.zd = zVelocity + (double)((float)(this.random.nextDouble() * 2.0 - 1.0) * 0.05f);
        this.quadSize = (this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f) * 1.0f / 5.0f;
        this.lifetime = Mth.ceil((float)(3.0f * (this.random.nextFloat() * 0.8f + 0.2f)));
        if (this.sprites != null) {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public Particle scale(float pScale) {
        return super.scale(pScale);
    }

    public void tick() {
        if (this.sprites != null) {
            this.setSpriteFromAge(this.sprites);
        }
        super.tick();
    }

    public static class SingleSpriteProvider<T extends GenericSpriteParticle>
    implements ParticleProvider.Sprite<EntityTrackingParticleOptions> {
        private final Factory<T> factory;

        public SingleSpriteProvider() {
            this(GenericSpriteParticle::new);
        }

        public SingleSpriteProvider(Factory<T> factory) {
            this.factory = factory;
        }

        public TextureSheetParticle createParticle(EntityTrackingParticleOptions data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return this.factory.create(level, x, y, z, xVelocity, yVelocity, zVelocity, null);
        }
    }

    public static class Provider<T extends GenericSpriteParticle>
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;
        private final Factory<T> factory;

        public Provider(SpriteSet sprites) {
            this(sprites, GenericSpriteParticle::new);
        }

        public Provider(SpriteSet sprites, Factory<T> factory) {
            this.sprites = sprites;
            this.factory = factory;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return this.factory.create(level, x, y, z, xVelocity, yVelocity, zVelocity, this.sprites);
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends GenericSpriteParticle> {
        public T create(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, @Nullable SpriteSet var14);
    }
}

