/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import org.jetbrains.annotations.Nullable;

public class EntityOrbitingParticle
extends TextureSheetParticle {
    private final Entity entity;
    private double startX;
    private double startY;
    private double startZ;

    public EntityOrbitingParticle(ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity, SpriteSet sprites, int entitySourceId) {
        super(level, x, y, z, xVelocity, yVelocity, zVelocity);
        this.xd = xVelocity;
        this.yd = yVelocity;
        this.zd = zVelocity;
        this.quadSize = (this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f) * 0.25f / 5.0f;
        this.lifetime = Mth.ceil((float)(25.0f / (this.random.nextFloat() * 0.8f + 0.2f)));
        this.hasPhysics = false;
        this.entity = this.level.getEntity(entitySourceId);
        if (this.entity != null) {
            this.startX = this.entity.getX();
            this.startY = this.entity.getY(0.5);
            this.startZ = this.entity.getZ();
        }
        this.pickSprite(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public int getLightColor(float partialTick) {
        float lerpAge = Mth.clamp((float)(((float)this.age + partialTick) / (float)this.lifetime), (float)0.0f, (float)1.0f) * 240.0f;
        int baseColour = super.getLightColor(partialTick);
        int colourMod = Math.min(240, (baseColour & 0xFF) + (int)lerpAge);
        return colourMod | (baseColour >> 16 & 0xFF) << 16;
    }

    public void tick() {
        if (this.entity == null || !this.entity.isAlive()) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        double slope = 0.3490658402442932;
        double angleX = Math.cos(slope);
        double angleZ = Math.sin(slope);
        double angleY = Math.cos(angleX + angleZ);
        Vec3 rotDelta = new Vec3(angleX * (this.x - this.startX) - angleZ * (this.z - this.startZ), angleY * (this.y - this.startY) * Math.tan(angleX + angleZ), angleZ * (this.x - this.startX) + angleX * (this.z - this.startZ)).normalize().scale(2.0).add(this.startX, this.startY, this.startZ);
        this.xd = rotDelta.x - this.x;
        this.yd = rotDelta.y - this.y;
        this.zd = rotDelta.z - this.z;
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public static class Provider
    implements ParticleProvider<EntityTrackingParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(EntityTrackingParticleOptions data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return new EntityOrbitingParticle(level, x, y, z, xVelocity, yVelocity, zVelocity, this.sprites, data.entitySourceId());
        }
    }
}

