/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entity.projectile.thrown;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;
import net.tslat.aoa3.content.entity.projectile.thrown.HellfireEntity;

public class HellfireModel
extends EntityModel<HellfireEntity> {
    private final ModelPart root;

    public HellfireModel(ModelPart meshDefRoot) {
        this.root = meshDefRoot.getChild("root");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.getRoot().addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 4.0f, 5.0f).texOffs(0, 9).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)16);
    }

    public void setupAnim(HellfireEntity hellfire, float pLimbSwing, float partialTicks, float tickAge, float pNetHeadYaw, float pHeadPitch) {
        if (hellfire.getDeltaMovement().x() != 0.0 || hellfire.getDeltaMovement().y() != 0.0 || hellfire.getDeltaMovement().z() != 0.0) {
            this.root.yRot = Mth.lerp((float)partialTicks, (float)(tickAge - 1.0f), (float)(tickAge % 360.0f));
            this.root.xRot = Mth.lerp((float)partialTicks, (float)(tickAge % 360.0f), (float)(tickAge + 1.0f));
            this.root.zRot = Mth.lerp((float)partialTicks, (float)(tickAge + 1.0f), (float)(tickAge + 2.0f));
        } else {
            this.root.xRot = 0.0f;
            this.root.yRot = 0.0f;
            this.root.zRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.root.render(matrixStack, buffer, packedLight, packedOverlay);
    }
}

