/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entity.projectile.thrown;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;

public class ChakramModel
extends EntityModel<BaseBullet> {
    private final ModelPart root;

    public ChakramModel(ModelPart modelDefRoot) {
        this.root = modelDefRoot.getChild("root");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootPart = meshDefinition.getRoot();
        PartDefinition root = rootPart.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("blades", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(-0.1f)).mirror().texOffs(0, 0).addBox(0.5f, -0.5f, -2.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(-0.1f)).mirror().texOffs(0, 6).addBox(-2.5f, -0.5f, -1.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).mirror().texOffs(0, 6).addBox(-2.5f, -0.5f, 0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.rotation((float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public void setupAnim(BaseBullet chakram, float pLimbSwing, float pLimbSwingAmount, float tickAge, float pNetHeadYaw, float pHeadPitch) {
        this.root.yRot = chakram.getDeltaMovement().x() != 0.0 || chakram.getDeltaMovement().y() != 0.0 || chakram.getDeltaMovement().z() != 0.0 ? Mth.lerp((float)pLimbSwingAmount, (float)(tickAge - 1.0f), (float)(tickAge % 360.0f)) : 0.0f;
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.root.render(matrixStack, buffer, packedLight, packedOverlay);
    }
}

