/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.entity.Entity;

public class CobblestoneProjectileModel
extends EntityModel<Entity> {
    private final ModelPart block;

    public CobblestoneProjectileModel(ModelPart meshDefRoot) {
        this.block = meshDefRoot.getChild("root");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.getRoot().addOrReplaceChild("root", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(-2.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.block.render(matrix, buffer, packedLight, packedOverlay, colour);
    }

    public void setupAnim(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.block.xRot += limbSwingAmount * 0.03f + 1.0f;
        this.block.yRot += limbSwingAmount * 0.03f + 1.0f;
        this.block.zRot += limbSwingAmount * 0.03f + 1.0f;
    }
}

