/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.util.RenderUtil;
import org.joml.Matrix4f;

public final class ScreenEffectRenderer {
    private static final CopyOnWriteArrayList<ScreenImageEffect> effects = new CopyOnWriteArrayList();

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterGuiLayersEvent.class, ev -> ev.registerAboveAll(AdventOfAscension.id("screen_effects"), ScreenEffectRenderer::onEffectRender));
    }

    public static void addScreenEffect(ScreenImageEffect effect) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        effect.init(mc.getWindow(), mc.level.getGameTime());
        effects.add(effect);
    }

    public static void clearOverlays() {
        effects.clear();
    }

    private static void onEffectRender(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON || effects.isEmpty() || Minecraft.getInstance().level == null) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        long gameTime = mc.level.getGameTime();
        boolean hasExpiredEffects = false;
        PoseStack poseStack = guiGraphics.pose();
        boolean rendered = false;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        for (ScreenImageEffect effect2 : effects) {
            if (effect2.isExpired(gameTime)) {
                hasExpiredEffects = true;
                continue;
            }
            rendered = true;
            float scale = effect2.getScale();
            float fadeTime = (float)(effect2.getExpiry() - gameTime) / (float)effect2.getDuration();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            poseStack.pushPose();
            RenderSystem.setShaderColor((float)effect2.getRed(), (float)effect2.getGreen(), (float)effect2.getBlue(), (float)(effect2.getAlpha() * fadeTime));
            RenderUtil.setRenderingTexture(effect2.getTexture());
            if (effect2.isFullscreen()) {
                buffer.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
                buffer.addVertex(0.0f, (float)window.getGuiScaledHeight(), -90.0f).setUv(0.0f, 1.0f);
                buffer.addVertex((float)window.getGuiScaledWidth(), (float)window.getGuiScaledHeight(), -90.0f).setUv(1.0f, 1.0f);
                buffer.addVertex((float)window.getGuiScaledWidth(), 0.0f, -90.0f).setUv(1.0f, 0.0f);
            } else {
                poseStack.translate(-256.0f, -256.0f, 0.0f);
                poseStack.scale(scale, scale, scale);
                poseStack.translate(effect2.x(), effect2.y(), 0.0f);
                Matrix4f pose = poseStack.last().pose();
                buffer.addVertex(pose, 0.0f, 256.0f, -90.0f).setUv(0.0f, 1.0f);
                buffer.addVertex(pose, 256.0f, 256.0f, -90.0f).setUv(1.0f, 1.0f);
                buffer.addVertex(pose, 256.0f, 0.0f, -90.0f).setUv(1.0f, 0.0f);
                buffer.addVertex(pose, 0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
            }
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            poseStack.popPose();
            RenderUtil.resetShaderColour();
        }
        if (rendered) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        if (hasExpiredEffects) {
            effects.removeIf(effect -> effect.isExpired(gameTime));
        }
    }
}

