/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.lib;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public abstract class ScrollablePane {
    private Minecraft mc;
    protected int top;
    protected int bottom;
    protected int left;
    protected int right;
    protected int viewWidth;
    protected int viewHeight;
    protected int scrollBarHeight;
    private float currentRenderScale;
    protected float mouseX;
    protected float mouseY;
    private boolean mouseFocussed;
    protected boolean isDragging = false;
    private float mouseYPosState = -2.0f;
    protected float distanceScrolled;
    private float scrollFactor;

    public ScrollablePane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
        this.currentRenderScale = renderingScale;
    }

    public void render(GuiGraphics guiGraphics, float mouseX, float mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int scrollBarWidth = 6;
        this.mouseFocussed = this.isMouseHovering();
        int paneHeight = this.getFullPaneHeight();
        int paneViewDiff = Math.max(0, paneHeight - this.viewHeight);
        if (paneViewDiff > 0) {
            this.scrollBarHeight = (int)Mth.clamp((float)((float)(this.viewHeight * this.viewHeight) / (float)paneHeight), (float)32.0f, (float)this.viewHeight);
        }
        if (this.isDragging) {
            if (this.mouseYPosState == -1.0f) {
                if (this.mouseFocussed) {
                    if (mouseX >= (float)(this.right - scrollBarWidth - 2) && mouseX <= (float)this.right) {
                        this.scrollFactor = -1.0f;
                        int scrollHeight = Math.max(paneHeight - this.viewHeight, 1);
                        this.scrollFactor /= (float)(this.viewHeight - this.scrollBarHeight) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.mouseYPosState = mouseY;
                } else {
                    this.mouseYPosState = -2.0f;
                }
            } else if (this.mouseYPosState >= 0.0f) {
                this.distanceScrolled -= (mouseY - this.mouseYPosState) * this.scrollFactor;
                this.mouseYPosState = mouseY;
            }
        } else {
            this.mouseYPosState = -1.0f;
        }
        this.distanceScrolled = Mth.clamp((float)this.distanceScrolled, (float)0.0f, (float)paneViewDiff);
        Window mcWindow = this.mc.getWindow();
        float windowWidthScale = this.currentRenderScale * ((float)mcWindow.getScreenWidth() / (float)mcWindow.getGuiScaledWidth());
        float windowHeightScale = this.currentRenderScale * ((float)mcWindow.getScreenHeight() / (float)mcWindow.getGuiScaledHeight());
        RenderSystem.enableScissor((int)((int)(((double)this.left - 1.5) * (double)windowWidthScale)), (int)((int)(((float)mcWindow.getScreenHeight() / windowHeightScale - (float)this.bottom - 2.0f) * windowHeightScale)), (int)((int)((float)(this.viewWidth + 3) * windowWidthScale)), (int)((int)(((double)this.viewHeight + 1.5) * (double)windowHeightScale + 2.0)));
        this.drawBackground(guiGraphics);
        guiGraphics.fillGradient(this.left - 1, this.top - 1, this.right + 1, this.bottom + 1, 0, -1072689136, -804253680);
        int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
        this.drawPaneContents(guiGraphics, newTop, this.left, this.right, this.bottom, this.distanceScrolled, partialTicks);
        RenderSystem.disableDepthTest();
        if (paneViewDiff > 0) {
            int barTop = Math.max((int)this.distanceScrolled * (this.viewHeight - this.scrollBarHeight) / paneViewDiff + this.top, this.top);
            int barLeft = this.right - 6;
            Tesselator tess = Tesselator.getInstance();
            BufferBuilder buff = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix4f = guiGraphics.pose().last().pose();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            buff.addVertex(matrix4f, (float)barLeft, (float)this.bottom, 0.0f).setUv(0.0f, 1.0f).setColor(0, 0, 0, 255);
            buff.addVertex(matrix4f, (float)(this.right + 1), (float)this.bottom, 0.0f).setUv(1.0f, 1.0f).setColor(0, 0, 0, 255);
            buff.addVertex(matrix4f, (float)(this.right + 1), (float)this.top, 0.0f).setUv(1.0f, 0.0f).setColor(0, 0, 0, 255);
            buff.addVertex(matrix4f, (float)barLeft, (float)this.top, 0.0f).setUv(0.0f, 0.0f).setColor(0, 0, 0, 255);
            BufferUploader.drawWithShader((MeshData)buff.buildOrThrow());
            buff = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buff.addVertex(matrix4f, (float)barLeft, (float)(barTop + this.scrollBarHeight), 0.0f).setUv(0.0f, 1.0f).setColor(128, 128, 128, 255);
            buff.addVertex(matrix4f, (float)(this.right + 1), (float)(barTop + this.scrollBarHeight), 0.0f).setUv(1.0f, 1.0f).setColor(128, 128, 128, 255);
            buff.addVertex(matrix4f, (float)(this.right + 1), (float)barTop, 0.0f).setUv(1.0f, 0.0f).setColor(128, 128, 128, 255);
            buff.addVertex(matrix4f, (float)barLeft, (float)barTop, 0.0f).setUv(0.0f, 0.0f).setColor(128, 128, 128, 255);
            BufferUploader.drawWithShader((MeshData)buff.buildOrThrow());
            buff = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buff.addVertex(matrix4f, (float)barLeft, (float)(barTop + this.scrollBarHeight - 1), 0.0f).setUv(0.0f, 1.0f).setColor(192, 192, 192, 255);
            buff.addVertex(matrix4f, (float)this.right, (float)(barTop + this.scrollBarHeight - 1), 0.0f).setUv(1.0f, 1.0f).setColor(192, 192, 192, 255);
            buff.addVertex(matrix4f, (float)this.right, (float)barTop, 0.0f).setUv(1.0f, 0.0f).setColor(192, 192, 192, 255);
            buff.addVertex(matrix4f, (float)barLeft, (float)barTop, 0.0f).setUv(0.0f, 0.0f).setColor(192, 192, 192, 255);
            BufferUploader.drawWithShader((MeshData)buff.buildOrThrow());
        }
        RenderSystem.disableBlend();
        RenderSystem.disableScissor();
    }

    public void onResize(Minecraft mc, int left, int top, int viewWidth, int viewHeight) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewHeight = viewHeight;
        this.viewWidth = viewWidth;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        this.isDragging = true;
        return this.isMouseHovering();
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return this.isMouseHovering();
    }

    public boolean handleMouseScroll(double mouseX, double mouseY, double scrollAmount) {
        if (!this.mouseFocussed) {
            return false;
        }
        if (scrollAmount != 0.0) {
            this.distanceScrolled += (float)(-20.0 * scrollAmount);
        }
        return this.isMouseHovering();
    }

    protected boolean isMouseHovering() {
        return this.mouseX >= (float)this.left && this.mouseX <= (float)this.right && this.mouseY >= (float)this.top && this.mouseY <= (float)this.bottom;
    }

    public abstract int getFullPaneHeight();

    public abstract void drawPaneContents(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6, float var7);

    public abstract void drawBackground(GuiGraphics var1);
}

