/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud.toasts;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.util.RenderUtil;

public class GenericToast
implements Toast {
    protected static final ResourceLocation ADVANCEMENT_TOAST_TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    protected final Component title;
    protected final Component message;

    public GenericToast(Component title, Component message) {
        this.title = title;
        this.message = message;
    }

    protected ResourceLocation getBackgroundTexture() {
        return ADVANCEMENT_TOAST_TEXTURE;
    }

    protected boolean stillValid() {
        return true;
    }

    protected int defaultLifeSpan() {
        return 5000;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (Minecraft.getInstance().level == null || !this.stillValid()) {
            return Toast.Visibility.HIDE;
        }
        this.drawBackground(guiGraphics, toastComponent, timeSinceLastVisible);
        this.drawIcon(guiGraphics, toastComponent, timeSinceLastVisible);
        this.drawTexts(guiGraphics, toastComponent, timeSinceLastVisible);
        return (double)timeSinceLastVisible >= (double)this.defaultLifeSpan() * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    protected void drawBackground(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        RenderUtil.resetShaderColour();
        guiGraphics.blitSprite(this.getBackgroundTexture(), 0, 0, this.width(), this.height());
    }

    protected void drawIcon(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
    }

    protected void drawTexts(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        PoseStack poseStack = guiGraphics.pose();
        int messageWidth = Minecraft.getInstance().font.width((FormattedText)this.message);
        RenderUtil.renderText(poseStack, this.title, 30.0f, 7.0f, -11534256, RenderUtil.TextRenderType.NORMAL);
        if (messageWidth <= 125) {
            RenderUtil.renderText(poseStack, this.message, 30.0f, 18.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
        } else {
            float scale = 125.0f / (float)messageWidth;
            poseStack.pushPose();
            poseStack.scale(scale, scale, 1.0f);
            RenderUtil.renderText(poseStack, this.message, 30.0f / scale, 18.0f / scale, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
            poseStack.popPose();
        }
    }
}

