/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.HolidayUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class XpParticlesRenderer {
    private static final ConcurrentHashMap<AoASkill, CopyOnWriteArrayList<XPParticle>> particlesMap = new ConcurrentHashMap(15);
    private static long lastPacketReceivedTime = 0L;
    private static XPParticle lastParticleReceived = null;
    private static AoASkill lastParticleSkill = null;

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterGuiLayersEvent.class, ev -> ev.registerAbove(VanillaGuiLayers.EFFECTS, AdventOfAscension.id("aoa_xp_particles"), XpParticlesRenderer::renderParticles));
    }

    public static void addXpParticle(AoASkill skill, float xp, boolean isLevelUp) {
        XPParticle particle;
        if (!particlesMap.containsKey(skill)) {
            particlesMap.put(skill, new CopyOnWriteArrayList());
        }
        if (lastParticleSkill == skill && lastParticleReceived != null && System.currentTimeMillis() <= lastPacketReceivedTime + 10L) {
            lastParticleReceived.modifyXp(xp, isLevelUp);
            if (XpParticlesRenderer.lastParticleReceived.levelUp) {
                CopyOnWriteArrayList<XPParticle> array = particlesMap.get(skill);
                if (!array.isEmpty()) {
                    array.removeLast();
                }
                array.addFirst(lastParticleReceived);
            }
            return;
        }
        if (isLevelUp) {
            particle = new XPParticle(xp, true);
            particlesMap.get(skill).addFirst(particle);
        } else {
            particle = new XPParticle(xp, false);
            particlesMap.get(skill).add(particle);
        }
        lastParticleReceived = particle;
        lastParticleSkill = skill;
        lastPacketReceivedTime = System.currentTimeMillis();
    }

    private static void renderParticles(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (particlesMap.isEmpty() || mc.options.hideGui) {
            return;
        }
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        long currentTime = System.currentTimeMillis();
        Window window = mc.getWindow();
        float scrollHeight = (float)window.getGuiScaledHeight() / 3.0f;
        int windowWidth = window.getGuiScaledWidth();
        int maxHeight = 0;
        int cumulativeXOffset = 0;
        int x = 0;
        int y = 0;
        boolean hasExpiredParticles = false;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)windowWidth / 2.0f, 1.0f, 0.0f);
        if (particlesMap.size() > 2) {
            poseStack.translate((float)Math.min(particlesMap.size(), 5) / 2.0f * 12.0f + 12.0f, 0.0f, 0.0f);
        }
        RenderSystem.disableDepthTest();
        for (Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>> entry : particlesMap.entrySet()) {
            AoASkill.Instance skill = ClientPlayerDataManager.get().getSkill(entry.getKey());
            CopyOnWriteArrayList<XPParticle> particles = entry.getValue();
            if (skill == AoASkills.DEFAULT || particles.isEmpty()) continue;
            AoASkillRenderer skillRenderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
            int renderWidth = skillRenderer.hudRenderWidth(skill);
            int renderHeight = skillRenderer.hudRenderHeight(skill);
            poseStack.pushPose();
            poseStack.translate((float)x, (float)y, 0.0f);
            poseStack.pushPose();
            poseStack.translate((double)renderWidth / 2.0, 0.0, 0.0);
            for (XPParticle particle : particles) {
                if (particle.creationTime <= currentTime - 1800L) {
                    hasExpiredParticles = true;
                    continue;
                }
                float lifespan = 1.0f - (float)(currentTime - particle.creationTime) / 1500.0f;
                if (!(lifespan >= 0.1f)) continue;
                RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)particle.xpString), 0.0f, scrollHeight * lifespan, 0.5f, ColourUtil.ARGB(255, 255, 255, (int)Mth.clamp((float)(255.0f * lifespan), (float)1.0f, (float)255.0f)), RenderUtil.TextRenderType.NORMAL);
            }
            poseStack.popPose();
            skillRenderer.renderInHud(RenderContext.of(guiGraphics), skill, partialTick, AoASkillRenderer.ProgressRenderType.Ring, false);
            if (particles.getFirst().levelUp) {
                String level = String.valueOf(skill.getLevel(true));
                float stringWidth = mc.font.width(level);
                float f = 1.0f / (stringWidth / (float)(renderWidth - 7));
                Objects.requireNonNull(mc.font);
                float scale = Math.min(f, 1.0f / (9.0f / (float)(renderHeight - 7)));
                poseStack.translate((double)renderWidth / 2.0, (double)renderHeight / 2.0, 0.0);
                MutableComponent mutableComponent = Component.literal((String)level);
                Objects.requireNonNull(mc.font);
                RenderUtil.renderCenteredScaledText(poseStack, (Component)mutableComponent, scale * 0.5f, (float)(-9) * scale / 2.5f, scale, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            }
            x -= renderWidth;
            maxHeight = Math.max(maxHeight, renderHeight);
            if ((cumulativeXOffset += renderWidth) >= 100) {
                y += maxHeight;
                x = 0;
                maxHeight = 0;
                cumulativeXOffset = 0;
            }
            poseStack.popPose();
        }
        RenderSystem.enableDepthTest();
        poseStack.popPose();
        if (hasExpiredParticles) {
            XpParticlesRenderer.purgeExpiredEntries();
        }
    }

    private static void purgeExpiredEntries() {
        if (!((Boolean)AoAConfigs.CLIENT.showXpParticles.get()).booleanValue()) {
            particlesMap.clear();
            return;
        }
        Iterator<Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>>> particleEntries = particlesMap.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        long expiryTime = currentTime - 1800L;
        while (particleEntries.hasNext()) {
            Map.Entry<AoASkill, CopyOnWriteArrayList<XPParticle>> entry = particleEntries.next();
            entry.getValue().removeIf(particle -> particle.creationTime <= expiryTime);
            if (!entry.getValue().isEmpty()) continue;
            particleEntries.remove();
        }
    }

    private static String getAprilFoolsXpString() {
        return (String)RandomUtil.getRandomSelection((Object[])new String[]{"Nice!", "69xp", "420xp", "-1xp", "422180734982xp", "Xp Get!", "GAINSSS", "5xp maybe?", "\u2308(\u23081*50^1.3\u2309/8+800)/46*37\u2309+6xp", "?", "Where am I?", "Weeeeeee!", "Going up!", "I'm sad", "Goodbye!"});
    }

    static class XPParticle {
        boolean levelUp;
        float xp;
        String xpString;
        protected long creationTime = System.currentTimeMillis();

        XPParticle(float xp, boolean isLevelUp) {
            this.levelUp = isLevelUp;
            this.xp = xp;
            this.xpString = HolidayUtil.isAprilFools() ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(xp, false);
        }

        protected void modifyXp(float additionalXp, boolean isLevelUp) {
            this.levelUp = this.levelUp || isLevelUp;
            this.xp += additionalXp;
            this.xpString = HolidayUtil.isAprilFools() ? XpParticlesRenderer.getAprilFoolsXpString() : "+" + NumberUtil.floorAndAppendSuffix(this.xp, false);
        }
    }
}

